/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

class UsageHolder {
    private final SmartPsiElementPointer myElementPointer;
    private int myUnsafeUsages;
    private int myNonCodeUnsafeUsages;

    public UsageHolder(PsiElement element, UsageInfo[] usageInfos) {
        Project project2 = element.getProject();
        this.myElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(element);
        for (UsageInfo usageInfo : usageInfos) {
            SafeDeleteReferenceUsageInfo usage;
            if (!(usageInfo instanceof SafeDeleteReferenceUsageInfo) || (usage = (SafeDeleteReferenceUsageInfo)usageInfo).getReferencedElement() != element || usage.isSafeDelete()) continue;
            ++this.myUnsafeUsages;
            if (!usage.isNonCodeUsage && !UsageHolder.isInGeneratedCode(usage, project2)) continue;
            ++this.myNonCodeUnsafeUsages;
        }
    }

    private static boolean isInGeneratedCode(SafeDeleteReferenceUsageInfo usage, Project project2) {
        VirtualFile file2 = usage.getVirtualFile();
        return file2 != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project2);
    }

    @NotNull
    public String getDescription() {
        PsiElement element = this.myElementPointer.getElement();
        String message2 = RefactoringBundle.message((String)"0.has.1.usages.that.are.not.safe.to.delete", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), this.myUnsafeUsages});
        if (this.myNonCodeUnsafeUsages > 0) {
            message2 = message2 + "<br>" + RefactoringBundle.message((String)"safe.delete.of.those.0.in.comments.strings.non.code", (Object[])new Object[]{this.myNonCodeUnsafeUsages});
        }
        return message2;
    }

    public boolean hasUnsafeUsagesInCode() {
        return this.myUnsafeUsages != this.myNonCodeUnsafeUsages;
    }
}

