/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationViewDescriptor;
import com.intellij.refactoring.typeMigration.ui.FailedConversionsDialog;
import com.intellij.refactoring.typeMigration.ui.MigrationPanel;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TypeMigrationProcessor
extends BaseRefactoringProcessor {
    private static final int MAX_ROOT_IN_PREVIEW_PRESENTATION = 3;
    private PsiElement[] myRoot;
    private final Function<PsiElement, PsiType> myRootTypes;
    private final TypeMigrationRules myRules;
    private TypeMigrationLabeler myLabeler;

    public TypeMigrationProcessor(Project project2, PsiElement[] roots, Function<PsiElement, PsiType> rootTypes, TypeMigrationRules rules) {
        super(project2);
        this.myRoot = roots;
        this.myRules = rules;
        this.myRootTypes = rootTypes;
    }

    public static void runHighlightingTypeMigration(Project project2, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project2, editor, rules, root, migrationType, false);
    }

    public static void runHighlightingTypeMigration(Project project2, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType, boolean optimizeImports) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project2, editor, rules, new PsiElement[]{root}, (Function<PsiElement, PsiType>)Functions.constant((Object)migrationType), optimizeImports);
    }

    public static void runHighlightingTypeMigration(final Project project2, final Editor editor, TypeMigrationRules rules, PsiElement[] roots, Function<PsiElement, PsiType> migrationTypeFunction, final boolean optimizeImports) {
        final Set containingFiles = ContainerUtil.map2Set((Object[])roots, element -> element.getContainingFile());
        TypeMigrationProcessor processor2 = new TypeMigrationProcessor(project2, roots, migrationTypeFunction, rules){

            @Override
            public void performRefactoring(@NotNull UsageInfo[] usages) {
                super.performRefactoring(usages);
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ArrayList<Object> result2 = new ArrayList<Object>();
                        for (UsageInfo usage : usages) {
                            PsiElement element = usage.getElement();
                            if (element == null || !containingFiles.contains(element.getContainingFile())) continue;
                            if (element instanceof PsiMethod) {
                                result2.add(((PsiMethod)element).getReturnTypeElement());
                                continue;
                            }
                            if (element instanceof PsiVariable) {
                                result2.add(((PsiVariable)element).getTypeElement());
                                continue;
                            }
                            result2.add(element);
                        }
                        RefactoringUtil.highlightAllOccurrences(project2, PsiUtilCore.toPsiElementArray(result2), editor);
                    });
                }
                if (optimizeImports) {
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                    THashSet affectedFiles = new THashSet();
                    for (UsageInfo usage : usages) {
                        PsiFile usageFile = usage.getFile();
                        if (usageFile == null) continue;
                        affectedFiles.add(usageFile);
                    }
                    for (PsiFile file2 : affectedFiles) {
                        javaCodeStyleManager.optimizeImports(file2);
                        javaCodeStyleManager.shortenClassReferences((PsiElement)file2);
                    }
                }
            }
        };
        processor2.run();
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new TypeMigrationViewDescriptor(this.myRoot[0]);
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (this.hasFailedConversions()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(StringUtil.join((String[])this.myLabeler.getFailedConversionsReport(), (String)"\n"));
            }
            FailedConversionsDialog dialog2 = new FailedConversionsDialog(this.myLabeler.getFailedConversionsReport(), this.myProject);
            if (!dialog2.showAndGet()) {
                int exitCode = dialog2.getExitCode();
                this.prepareSuccessful();
                if (exitCode == 2) {
                    this.previewRefactoring((UsageInfo[])refUsages.get());
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    public boolean hasFailedConversions() {
        return this.myLabeler.hasFailedConversions();
    }

    @Override
    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        String name;
        MigrationPanel panel2 = new MigrationPanel(this.myRoot, this.myLabeler, this.myProject, this.isPreviewUsages());
        if (this.myRoot.length == 1) {
            String fromType = ((PsiType)ObjectUtils.assertNotNull((Object)TypeMigrationLabeler.getElementType(this.myRoot[0]))).getPresentableText();
            String toType = ((PsiType)this.myRootTypes.fun((Object)this.myRoot[0])).getPresentableText();
            String text = TypeMigrationProcessor.getPresentation(this.myRoot[0]);
            name = "Migrate Type of " + text + " from '" + fromType + "' to '" + toType + "'";
        } else {
            int rootsInPresentationCount = this.myRoot.length > 3 ? 3 : this.myRoot.length;
            String[] rootsPresentation = new String[rootsInPresentationCount];
            for (int i2 = 0; i2 < rootsInPresentationCount; ++i2) {
                PsiElement root = this.myRoot[i2];
                rootsPresentation[i2] = root instanceof PsiNamedElement ? ((PsiNamedElement)root).getName() : root.getText();
            }
            rootsPresentation = StringUtil.surround((String[])rootsPresentation, (String)"'", (String)"'");
            name = "Migrate Type of " + StringUtil.join((String[])rootsPresentation, (String)", ");
            if (this.myRoot.length > 3) {
                name = name + "...";
            }
        }
        Content content = UsageViewManager.getInstance((Project)this.myProject).addContent(name, false, (JComponent)panel2, true, true);
        panel2.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.FIND).activate(null);
    }

    public static String getPresentation(PsiElement element) {
        String text = element instanceof PsiField ? "field '" + ((PsiField)element).getName() + "'" : (element instanceof PsiParameter ? "parameter '" + ((PsiParameter)element).getName() + "'" : (element instanceof PsiLocalVariable ? "variable '" + ((PsiLocalVariable)element).getName() + "'" : (element instanceof PsiMethod ? "method '" + ((PsiMethod)element).getName() + "' return" : element.getText())));
        return text;
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        this.myLabeler = new TypeMigrationLabeler(this.myRules, this.myRootTypes);
        try {
            return this.myLabeler.getMigratedUsages(!this.isPreviewUsages(), this.myRoot);
        }
        catch (TypeMigrationLabeler.MigrateException e) {
            this.setPreviewUsages(true);
            this.myLabeler.clearStopException();
            return this.myLabeler.getMigratedUsages(false, this.myRoot);
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        this.myRoot = elements;
    }

    @Override
    public void performRefactoring(@NotNull UsageInfo[] usages) {
        TypeMigrationProcessor.change(usages, this.myLabeler, this.myProject);
    }

    public static void change(UsageInfo[] usages, TypeMigrationLabeler labeler, Project project2) {
        SmartList newExpressionsToCheckDiamonds = new SmartList();
        TypeMigrationLabeler.MigrationProducer producer = labeler.createMigratorFor(usages);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project2);
        ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (((TypeMigrationUsageInfo)usage).isExcluded()) continue;
            PsiElement element = usage.getElement();
            if (element instanceof PsiVariable || element instanceof PsiMember || element instanceof PsiExpression || element instanceof PsiReferenceParameterList) {
                producer.change((TypeMigrationUsageInfo)usage, (Consumer<PsiNewExpression>)((Consumer)arg_0 -> TypeMigrationProcessor.lambda$change$1((List)newExpressionsToCheckDiamonds, smartPointerManager, arg_0)));
                continue;
            }
            nonCodeUsages.add(usage);
        }
        for (SmartPsiElementPointer newExpressionPointer : newExpressionsToCheckDiamonds) {
            PsiNewExpression newExpression = (PsiNewExpression)newExpressionPointer.getElement();
            if (newExpression == null) continue;
            labeler.postProcessNewExpression(newExpression);
        }
        for (UsageInfo usageInfo : nonCodeUsages) {
            Object target;
            PsiReference reference;
            PsiElement element = usageInfo.getElement();
            if (element == null || (reference = element.getReference()) == null || !((target = producer.getConversion(usageInfo)) instanceof PsiMember)) continue;
            try {
                reference.bindToElement((PsiElement)target);
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        producer.flush();
    }

    public TypeMigrationLabeler getLabeler() {
        return this.myLabeler;
    }

    @Override
    protected String getCommandName() {
        return "TypeMigration";
    }

    private static /* synthetic */ void lambda$change$1(List newExpressionsToCheckDiamonds, SmartPointerManager smartPointerManager, PsiNewExpression expression2) {
        newExpressionsToCheckDiamonds.add(smartPointerManager.createSmartPsiElementPointer((PsiElement)expression2));
    }
}

