/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaFluentIterableConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicateConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(GuavaInspection.class);
    private static final Set<String> FLUENT_ITERABLE_STOP_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"append", "cycle", "uniqueIndex", "index", "toMultiset"});
    public static final String PROBLEM_DESCRIPTION = "Guava's functional primitives can be replaced by Java API";
    public boolean checkVariables = true;
    public boolean checkChains = true;
    public boolean checkReturnTypes = true;
    public boolean ignoreJavaxNullable = true;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Report variables", "checkVariables");
        panel2.addCheckbox("Report method chains", "checkChains");
        panel2.addCheckbox("Report return types", "checkReturnTypes");
        panel2.addCheckbox("Erase @javax.annotations.Nullable from converted functions", "ignoreJavaxNullable");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){
            private final AtomicNotNullLazyValue<Map<String, PsiClass>> myGuavaClassConversions = new AtomicNotNullLazyValue<Map<String, PsiClass>>(){

                @NotNull
                protected Map<String, PsiClass> compute() {
                    HashMap map2 = new HashMap();
                    for (TypeConversionRule rule : (TypeConversionRule[])TypeConversionRule.EP_NAME.getExtensions()) {
                        if (!(rule instanceof BaseGuavaTypeConversionRule)) continue;
                        String fromClass = ((BaseGuavaTypeConversionRule)rule).ruleFromClass();
                        String toClass = ((BaseGuavaTypeConversionRule)rule).ruleToClass();
                        Project project2 = holder.getProject();
                        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
                        PsiClass targetClass = javaPsiFacade.findClass(toClass, GlobalSearchScope.allScope((Project)project2));
                        if (targetClass == null) continue;
                        map2.put(fromClass, targetClass);
                    }
                    return map2;
                }
            };

            public void visitVariable(PsiVariable variable) {
                if (!GuavaInspection.this.checkVariables) {
                    return;
                }
                PsiType type2 = variable.getType();
                PsiType targetType = this.getConversionClassType(type2);
                if (targetType != null) {
                    holder.registerProblem((PsiElement)variable.getNameIdentifier(), GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)variable, targetType)});
                }
            }

            public void visitMethod(PsiMethod method2) {
                PsiTypeElement typeElement;
                super.visitMethod(method2);
                if (!GuavaInspection.this.checkReturnTypes) {
                    return;
                }
                PsiType targetType = this.getConversionClassType(method2.getReturnType());
                if (targetType != null && (typeElement = method2.getReturnTypeElement()) != null) {
                    holder.registerProblem((PsiElement)typeElement, GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)method2, targetType)});
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                this.checkFluentIterableGenerationMethod(expression2);
                this.checkPredicatesUtilityMethod(expression2);
            }

            private void checkPredicatesUtilityMethod(PsiMethodCallExpression expression2) {
                if (GuavaPredicateConversionRule.isPredicates(expression2)) {
                    PsiClassType initialType = (PsiClassType)expression2.getType();
                    PsiClassType targetType = this.createTargetType(initialType);
                    if (targetType == null) {
                        return;
                    }
                    holder.registerProblem(expression2.getMethodExpression().getReferenceNameElement(), GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)expression2, (PsiType)targetType)});
                }
            }

            private void checkFluentIterableGenerationMethod(PsiMethodCallExpression expression2) {
                if (!GuavaInspection.this.checkChains) {
                    return;
                }
                if (!this.isFluentIterableFromCall(expression2)) {
                    return;
                }
                PsiMethodCallExpression chain = this.findGuavaMethodChain(expression2);
                if (chain == null) {
                    return;
                }
                PsiClassType initialType = (PsiClassType)chain.getType();
                LOG.assertTrue(initialType != null);
                PsiClassType targetType = this.createTargetType(initialType);
                if (targetType == null) {
                    return;
                }
                PsiMethodCallExpression highlightedElement = chain;
                if (chain.getParent() instanceof PsiReferenceExpression && chain.getParent().getParent() instanceof PsiMethodCallExpression) {
                    highlightedElement = chain.getParent().getParent();
                }
                holder.registerProblem((PsiElement)highlightedElement, GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)chain, (PsiType)targetType)});
            }

            @Nullable
            private PsiClassType createTargetType(PsiClassType initialType) {
                PsiClass target;
                PsiClass resolvedClass = initialType.resolve();
                if (resolvedClass == null || (target = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(resolvedClass.getQualifiedName())) == null) {
                    return null;
                }
                return this.addTypeParameters((PsiType)initialType, initialType.resolveGenerics(), target);
            }

            private PsiType getConversionClassType(PsiType initialType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (initialType == null) {
                    return null;
                }
                PsiType type2 = initialType.getDeepComponentType();
                if (type2 instanceof PsiClassType && (psiClass = (resolveResult = ((PsiClassType)type2).resolveGenerics()).getElement()) != null) {
                    String qName = psiClass.getQualifiedName();
                    PsiClass targetClass = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(qName);
                    if (targetClass != null) {
                        PsiClassType createdType = this.addTypeParameters(type2, resolveResult, targetClass);
                        return initialType instanceof PsiArrayType ? this.wrapAsArray((PsiArrayType)initialType, (PsiType)createdType) : createdType;
                    }
                }
                return null;
            }

            private PsiType wrapAsArray(PsiArrayType initial, PsiType created) {
                PsiArrayType result2 = new PsiArrayType(created);
                while (initial.getComponentType() instanceof PsiArrayType) {
                    initial = (PsiArrayType)initial.getComponentType();
                    result2 = new PsiArrayType((PsiType)result2);
                }
                return result2;
            }

            private boolean isFluentIterableFromCall(PsiMethodCallExpression expression2) {
                PsiMethod method2 = expression2.resolveMethod();
                if (method2 == null || !GuavaFluentIterableConversionRule.CHAIN_HEAD_METHODS.contains(method2.getName())) {
                    return false;
                }
                PsiClass aClass = method2.getContainingClass();
                return aClass != null && ("com.google.common.base.Optional".equals(aClass.getQualifiedName()) || "com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName()));
            }

            private PsiMethodCallExpression findGuavaMethodChain(PsiMethodCallExpression expression2) {
                PsiMethodCallExpression chain = expression2;
                while (true) {
                    PsiMethodCallExpression current;
                    if ((current = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)chain, PsiMethodCallExpression.class)) != null && current.getMethodExpression().getQualifierExpression() == chain) {
                        PsiMethod method2 = current.resolveMethod();
                        if (method2 == null) {
                            return chain;
                        }
                        if (FLUENT_ITERABLE_STOP_METHODS.contains(method2.getName())) {
                            return null;
                        }
                        PsiClass containingClass = method2.getContainingClass();
                        if (containingClass == null || !"com.google.common.collect.FluentIterable".equals(containingClass.getQualifiedName()) && !"com.google.common.base.Optional".equals(containingClass.getQualifiedName())) {
                            return chain;
                        }
                        PsiType returnType = method2.getReturnType();
                        PsiClass returnClass = PsiTypesUtil.getPsiClass((PsiType)returnType);
                        if (returnClass == null || !"com.google.common.collect.FluentIterable".equals(returnClass.getQualifiedName()) && !"com.google.common.base.Optional".equals(returnClass.getQualifiedName())) {
                            return chain;
                        }
                        if (GuavaTypeConversionDescriptor.isIterable((PsiExpression)current)) {
                            return chain;
                        }
                    } else {
                        return chain;
                    }
                    chain = current;
                }
            }

            @NotNull
            private PsiClassType addTypeParameters(PsiType currentType, PsiClassType.ClassResolveResult currentTypeResolveResult, PsiClass targetClass) {
                Map substitutionMap = currentTypeResolveResult.getSubstitutor().getSubstitutionMap();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)holder.getProject());
                if (substitutionMap.size() == 1) {
                    return elementFactory.createType(targetClass, (PsiType)ContainerUtil.getFirstItem(substitutionMap.values()));
                }
                LOG.assertTrue(substitutionMap.size() == 2);
                LOG.assertTrue(GuavaLambda.FUNCTION.getJavaAnalogueClassQName().equals(targetClass.getQualifiedName()));
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
                ArrayList types = new ArrayList(substitutionMap.values());
                types.remove(returnType);
                PsiType parameterType = (PsiType)types.get(0);
                return elementFactory.createType(targetClass, new PsiType[]{parameterType, returnType});
            }
        };
    }

    public class MigrateGuavaTypeFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements BatchQuickFix<CommonProblemDescriptor> {
        private final PsiType myTargetType;

        private MigrateGuavaTypeFix(PsiElement element, PsiType targetType) {
            super(element);
            this.myTargetType = targetType;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.performTypeMigration(Collections.singletonList(startElement), Collections.singletonList(this.myTargetType));
        }

        protected boolean isAvailable() {
            return super.isAvailable() && this.myTargetType.isValid();
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            if (!this.myTargetType.isValid() || !element.isValid()) {
                return this.getFamilyName();
            }
            String presentation = element instanceof PsiMethodCallExpression ? "method chain" : TypeMigrationProcessor.getPresentation(element);
            return "Migrate " + presentation + " type to '" + this.myTargetType.getCanonicalText(false) + "'";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Migrate Guava's type to Java";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            ArrayList<PsiElement> elementsToFix = new ArrayList<PsiElement>();
            ArrayList<PsiType> migrationTypes = new ArrayList<PsiType>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                MigrateGuavaTypeFix fix = this.getFix(descriptor);
                elementsToFix.add(fix.getStartElement());
                migrationTypes.add(fix.myTargetType);
            }
            if (!elementsToFix.isEmpty()) {
                this.performTypeMigration(elementsToFix, migrationTypes);
            }
        }

        private MigrateGuavaTypeFix getFix(CommonProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            LOG.assertTrue(fixes != null);
            for (QuickFix fix : fixes) {
                if (!(fix instanceof MigrateGuavaTypeFix)) continue;
                return (MigrateGuavaTypeFix)fix;
            }
            throw new AssertionError();
        }

        private void performTypeMigration(List<PsiElement> elements, List<PsiType> types) {
            PsiFile containingFile = null;
            for (PsiElement element : elements) {
                PsiFile currentContainingFile = element.getContainingFile();
                if (containingFile == null) {
                    containingFile = currentContainingFile;
                    continue;
                }
                LOG.assertTrue(containingFile.isEquivalentTo((PsiElement)currentContainingFile));
            }
            LOG.assertTrue(containingFile != null);
            if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
                return;
            }
            try {
                TypeMigrationRules rules = new TypeMigrationRules();
                rules.setBoundScope((SearchScope)GlobalSearchScopesCore.projectProductionScope((Project)containingFile.getProject()).union((SearchScope)GlobalSearchScopesCore.projectTestScope((Project)containingFile.getProject())));
                rules.addConversionRuleSettings(new GuavaConversionSettings(GuavaInspection.this.ignoreJavaxNullable));
                TypeMigrationProcessor.runHighlightingTypeMigration(containingFile.getProject(), null, rules, elements.toArray(new PsiElement[elements.size()]), this.createMigrationTypeFunction(elements, types), true);
                UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private Function<PsiElement, PsiType> createMigrationTypeFunction(@NotNull List<PsiElement> elements, @NotNull List<PsiType> types) {
            LOG.assertTrue(elements.size() == types.size());
            HashMap mappings = new HashMap();
            Iterator<PsiType> typeIterator = types.iterator();
            for (PsiElement element : elements) {
                PsiType type2 = typeIterator.next();
                mappings.put(element, type2);
            }
            return arg_0 -> MigrateGuavaTypeFix.lambda$createMigrationTypeFunction$0((Map)mappings, arg_0);
        }

        private static /* synthetic */ PsiType lambda$createMigrationTypeFunction$0(Map mappings, PsiElement element) {
            return (PsiType)mappings.get(element);
        }
    }
}

