/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.inspections;

import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateAssertToMatcherAssertInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(MigrateAssertToMatcherAssertInspection.class);
    private static final Map<String, Pair<String, String>> ASSERT_METHODS = new HashMap();
    public boolean myStaticallyImportMatchers = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Statically import matcher's methods", (InspectionProfileEntry)this, "myStaticallyImportMatchers");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (JavaPsiFacade.getInstance((Project)holder.getProject()).findClass("org.hamcrest.CoreMatchers", holder.getFile().getResolveScope()) == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass assertClass;
                String methodName = expression2.getMethodExpression().getReferenceName();
                if (!ASSERT_METHODS.containsKey(methodName)) {
                    return;
                }
                PsiMethod assertMethod = expression2.resolveMethod();
                if (assertMethod == null || (assertClass = assertMethod.getContainingClass()) == null) {
                    return;
                }
                if (!"junit.framework.Assert".equals(assertClass.getQualifiedName()) && !"org.junit.Assert".equals(assertClass.getQualifiedName())) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2.getMethodExpression(), "Assert expression <code>#ref</code> can be replaced with 'assertThat' call #loc", new LocalQuickFix[]{new MyQuickFix()});
            }
        };
    }

    private static IElementType negate(IElementType tokenType) {
        if (JavaTokenType.GT.equals(tokenType)) {
            return JavaTokenType.LE;
        }
        if (JavaTokenType.LT.equals(tokenType)) {
            return JavaTokenType.GE;
        }
        if (JavaTokenType.GE.equals(tokenType)) {
            return JavaTokenType.LT;
        }
        if (JavaTokenType.LE.equals(tokenType)) {
            return JavaTokenType.GT;
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> getSuitableMatcherForMethodCallInsideBooleanAssert(PsiMethodCallExpression expression2, boolean negate) {
        PsiMethod method2;
        String methodName = expression2.getMethodExpression().getReferenceName();
        String fromTemplate = null;
        String toLeftPart = null;
        String toRightPart = null;
        if ("contains".equals(methodName)) {
            PsiClass containingClass;
            PsiMethod method3 = expression2.resolveMethod();
            if (method3 != null && (containingClass = method3.getContainingClass()) != null) {
                if ("java.lang.String".equals(containingClass.getQualifiedName())) {
                    fromTemplate = "$str$.contains($sub$)";
                    toLeftPart = "$str$, ";
                    toRightPart = "org.hamcrest.CoreMatchers.containsString($sub$)";
                } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) {
                    fromTemplate = "$collection$.contains($element$)";
                    toLeftPart = "$collection$, ";
                    toRightPart = "org.hamcrest.CoreMatchers.hasItem($element$)";
                }
            }
        } else if ("equals".equals(methodName) && (method2 = expression2.resolveMethod()) != null && MigrateAssertToMatcherAssertInspection.isUniqueObjectParameter(method2.getParameterList())) {
            fromTemplate = "$left$.equals($right$)";
            toLeftPart = "$left$, ";
            toRightPart = "org.hamcrest.CoreMatchers.is($right$)";
        }
        if (fromTemplate == null) {
            return null;
        }
        if (negate) {
            toRightPart = "org.hamcrest.CoreMatchers.not(" + toRightPart + ")";
        }
        return Pair.create((Object)fromTemplate, (Object)(toLeftPart + toRightPart));
    }

    private static boolean isUniqueObjectParameter(PsiParameterList parameters2) {
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = parameters2.getParameters()[0];
        PsiClass parameterClass = PsiTypesUtil.getPsiClass((PsiType)parameter.getType());
        return parameterClass != null && "java.lang.Object".equals(parameterClass.getQualifiedName());
    }

    private static boolean hasMessage(PsiMethod method2) {
        PsiParameter maybeMessage = method2.getParameterList().getParameters()[0];
        PsiClass maybeString = PsiTypesUtil.getPsiClass((PsiType)maybeMessage.getType());
        return maybeString != null && "java.lang.String".equals(maybeString.getQualifiedName());
    }

    static {
        ASSERT_METHODS.put("assertArrayEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, org.hamcrest.CoreMatchers.is($expected$)"));
        ASSERT_METHODS.put("assertEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, org.hamcrest.CoreMatchers.is($expected$)"));
        ASSERT_METHODS.put("assertNotEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, org.hamcrest.CoreMatchers.not(org.hamcrest.CoreMatchers.is($expected$))"));
        ASSERT_METHODS.put("assertSame", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, org.hamcrest.CoreMatchersSame.sameInstance($expected$)"));
        ASSERT_METHODS.put("assertNotSame", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, org.hamcrest.CoreMatchers.not(org.hamcrest.CoreMatchersSame.sameInstance($expected$))"));
        ASSERT_METHODS.put("assertNotNull", (Pair<String, String>)Pair.create((Object)"$obj$", (Object)"$obj$, org.hamcrest.CoreMatchers.notNullValue()"));
        ASSERT_METHODS.put("assertNull", (Pair<String, String>)Pair.create((Object)"$obj$", (Object)"$obj$, org.hamcrest.CoreMatchers.nullValue()"));
        ASSERT_METHODS.put("assertTrue", (Pair<String, String>)Pair.create((Object)"$cond$", (Object)"$cond$, org.hamcrest.CoreMatchers.is(true)"));
        ASSERT_METHODS.put("assertFalse", (Pair<String, String>)Pair.create((Object)"$cond$", (Object)"$cond$, org.hamcrest.CoreMatchers.is(false)"));
    }

    public class MyQuickFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with 'assertThat'";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression replaced;
            PsiElement element = descriptor.getPsiElement();
            if (element == null || !element.isValid() || !(element.getParent() instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element.getParent();
            PsiMethod method2 = methodCall.resolveMethod();
            if (method2 == null) {
                return;
            }
            String methodName = method2.getName();
            Pair templatePair = null;
            if ("assertFalse".equals(methodName) || "assertTrue".equals(methodName)) {
                PsiExpression[] expressions2 = methodCall.getArgumentList().getExpressions();
                PsiExpression conditionExpression = expressions2[expressions2.length - 1];
                boolean negate = methodName.contains("False");
                if (conditionExpression instanceof PsiBinaryExpression) {
                    templatePair = this.getSuitableMatcherForBinaryExpressionInsideBooleanAssert((PsiBinaryExpression)conditionExpression, negate);
                } else if (conditionExpression instanceof PsiMethodCallExpression) {
                    templatePair = MigrateAssertToMatcherAssertInspection.getSuitableMatcherForMethodCallInsideBooleanAssert((PsiMethodCallExpression)conditionExpression, negate);
                }
            }
            if (templatePair == null) {
                templatePair = (Pair)ASSERT_METHODS.get(methodName);
            }
            LOG.assertTrue(templatePair != null);
            templatePair = this.buildFullTemplate((Pair<String, String>)templatePair, method2);
            try {
                replaced = TypeConversionDescriptor.replaceExpression((PsiExpression)methodCall, (String)templatePair.getFirst(), (String)templatePair.getSecond());
            }
            catch (IncorrectOperationException e) {
                LOG.error("Replacer can't match expression:\n" + methodCall.getText() + "\nwith replacement template:\n(" + (String)templatePair.getFirst() + ", " + (String)templatePair.getSecond() + ")");
                throw e;
            }
            if (MigrateAssertToMatcherAssertInspection.this.myStaticallyImportMatchers) {
                for (PsiJavaCodeReferenceElement ref : ContainerUtil.reverse(new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)replaced, PsiJavaCodeReferenceElement.class)))) {
                    PsiIdentifier identifier;
                    String qName;
                    PsiElement resolvedElement;
                    if (!ref.isValid() || !((resolvedElement = ref.resolve()) instanceof PsiClass) || (qName = ((PsiClass)resolvedElement).getQualifiedName()) == null || !qName.startsWith("org.hamcrest") || (identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)ref, PsiIdentifier.class)) == null) continue;
                    AddOnDemandStaticImportAction.invoke(project2, replaced.getContainingFile(), null, (PsiElement)identifier);
                }
            }
        }

        private Pair<String, String> buildFullTemplate(Pair<String, String> templatePair, PsiMethod method2) {
            if (templatePair == null) {
                return null;
            }
            boolean hasMessage = MigrateAssertToMatcherAssertInspection.hasMessage(method2);
            String searchTemplate = "'Assert*." + method2.getName() + "(" + (hasMessage ? "$msg$, " : "") + (String)templatePair.getFirst() + ")";
            PsiClass containingClass = method2.getContainingClass();
            LOG.assertTrue(containingClass != null);
            String qualifier = containingClass.getQualifiedName();
            LOG.assertTrue(qualifier != null);
            String replaceTemplate = qualifier + ".assertThat(" + (hasMessage ? "$msg$, " : "") + (String)templatePair.getSecond() + ")";
            return Pair.create((Object)searchTemplate, (Object)replaceTemplate);
        }

        @Nullable
        private Pair<String, String> getSuitableMatcherForBinaryExpressionInsideBooleanAssert(PsiBinaryExpression expression2, boolean negate) {
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (negate) {
                tokenType = MigrateAssertToMatcherAssertInspection.negate(tokenType);
            }
            String fromTemplate = "$left$ " + sign.getText() + "  $right$";
            if (JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.NE.equals(tokenType)) {
                String rightPartOfAfterTemplate;
                boolean isEqEqForPrimitives = true;
                for (PsiExpression operand2 : ContainerUtil.list((Object[])new PsiExpression[]{expression2.getLOperand(), expression2.getROperand()})) {
                    if (operand2.getType() instanceof PsiPrimitiveType) continue;
                    isEqEqForPrimitives = false;
                    break;
                }
                String string = rightPartOfAfterTemplate = isEqEqForPrimitives ? "org.hamcrest.CoreMatchers.is($right$)" : "org.hamcrest.CoreMatchers.sameInstance($right$)";
                if (JavaTokenType.NE.equals(tokenType)) {
                    rightPartOfAfterTemplate = "org.hamcrest.CoreMatchers.not(" + rightPartOfAfterTemplate + ")";
                }
                return Pair.create((Object)fromTemplate, (Object)("$left$, " + rightPartOfAfterTemplate));
            }
            String replaceTemplate = null;
            if (JavaTokenType.GT.equals(tokenType)) {
                replaceTemplate = "greaterThan($right$)";
            } else if (JavaTokenType.LT.equals(tokenType)) {
                replaceTemplate = "lessThan($right$)";
            } else if (JavaTokenType.GE.equals(tokenType)) {
                replaceTemplate = "greaterThanOrEqualTo($right$)";
            } else if (JavaTokenType.LE.equals(tokenType)) {
                replaceTemplate = "lessThanOrEqualTo($right$)";
            }
            if (replaceTemplate == null) {
                return null;
            }
            replaceTemplate = "org.hamcrest.number.OrderingComparison." + replaceTemplate;
            return Pair.create((Object)fromTemplate, (Object)("$left$, " + replaceTemplate));
        }
    }
}

