/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import org.jetbrains.annotations.NotNull;

public class RootTypeConversionRule
extends TypeConversionRule {
    @Override
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiClass targetClass;
        if (member != null && to instanceof PsiClassType && from instanceof PsiClassType && (targetClass = ((PsiClassType)to).resolve()) != null && member.isPhysical()) {
            PsiClass fieldContainingClass;
            if (member instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)member;
                PsiMethod replacer = targetClass.findMethodBySignature(method2, true);
                if (replacer == null) {
                    for (PsiMethod superMethod : method2.findDeepestSuperMethods()) {
                        replacer = targetClass.findMethodBySignature(superMethod, true);
                        if (replacer == null) continue;
                        method2 = superMethod;
                        break;
                    }
                }
                if (replacer != null) {
                    boolean isValid;
                    boolean isStaticMethodConversion = replacer.hasModifierProperty("static");
                    boolean bl = isStaticMethodConversion ? TypeConversionUtil.areTypesConvertible((PsiType)method2.getReturnType(), (PsiType)from) && TypeConversionUtil.areTypesConvertible((PsiType)replacer.getReturnType(), (PsiType)to) : (isValid = TypeConversionUtil.areTypesConvertible((PsiType)method2.getReturnType(), (PsiType)replacer.getReturnType()));
                    if (isValid) {
                        PsiType functionalInterfaceType;
                        PsiElement parent = context.getParent();
                        if (context instanceof PsiMethodReferenceExpression && Comparing.equal((Object)(functionalInterfaceType = ((PsiMethodReferenceExpression)context).getFunctionalInterfaceType()), (Object)to) && method2.isEquivalentTo((PsiElement)LambdaUtil.getFunctionalInterfaceMethod((PsiType)from))) {
                            return new TypeConversionDescriptorBase(){

                                @Override
                                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                                    PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression2;
                                    PsiExpression qualifierExpression2 = methodReferenceExpression.getQualifierExpression();
                                    if (qualifierExpression2 != null) {
                                        return (PsiExpression)expression2.replace((PsiElement)qualifierExpression2);
                                    }
                                    return expression2;
                                }
                            };
                        }
                        if (context instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
                            PsiType evaluatedQualifierType;
                            JavaResolveResult resolveResult = ((PsiReferenceExpression)context).advancedResolve(false);
                            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent).getMethodExpression();
                            PsiExpression qualifier = methodExpression.getQualifierExpression();
                            PsiClass substitutionClass = method2.getContainingClass();
                            PsiSubstitutor aSubst = qualifier != null ? ((evaluatedQualifierType = labeler.getTypeEvaluator().evaluateType(qualifier)) instanceof PsiClassType ? ((PsiClassType)evaluatedQualifierType).resolveGenerics().getSubstitutor() : PsiSubstitutor.EMPTY) : TypeConversionUtil.getClassSubstitutor((PsiClass)member.getContainingClass(), (PsiClass)substitutionClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                            PsiParameter[] originalParams = ((PsiMethod)member).getParameterList().getParameters();
                            PsiParameter[] migrationParams = replacer.getParameterList().getParameters();
                            PsiExpression[] actualParams = ((PsiMethodCallExpression)parent).getArgumentList().getExpressions();
                            assert (originalParams.length == migrationParams.length);
                            PsiSubstitutor methodTypeParamsSubstitutor = labeler.getTypeEvaluator().createMethodSubstitution(originalParams, actualParams, method2, context, aSubst != null ? aSubst : PsiSubstitutor.EMPTY, true);
                            for (int i2 = 0; i2 < originalParams.length; ++i2) {
                                PsiType migrationType;
                                PsiType originalType = resolveResult.getSubstitutor().substitute(originalParams[i2].getType());
                                PsiType type2 = migrationParams[i2].getType();
                                if (InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)substitutionClass, (boolean)true)) {
                                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)substitutionClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                                    assert (superClassSubstitutor != null);
                                    type2 = superClassSubstitutor.substitute(type2);
                                }
                                if (originalType.equals(migrationType = methodTypeParamsSubstitutor.substitute(type2)) || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)migrationType, (PsiExpression)actualParams[i2])) continue;
                                labeler.migrateExpressionType(actualParams[i2], migrationType, (PsiElement)context, false, true);
                            }
                        }
                        return isStaticMethodConversion ? new MyStaticMethodConversionDescriptor(targetClass) : new TypeConversionDescriptorBase();
                    }
                }
            } else if (member instanceof PsiField && InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)(fieldContainingClass = member.getContainingClass()), (boolean)true)) {
                return new TypeConversionDescriptorBase();
            }
        }
        return null;
    }

    private static class MyStaticMethodConversionDescriptor
    extends TypeConversionDescriptorBase {
        @NotNull
        private final String myTargetClassQName;

        private MyStaticMethodConversionDescriptor(PsiClass replacer) {
            this.myTargetClassQName = replacer.getQualifiedName();
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            PsiMethodCallExpression newMethodCall;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            if (qualifierExpression2 != null) {
                JavaCodeStyleManager.getInstance((Project)expression2.getProject()).shortenClassReferences(qualifierExpression2.replace((PsiElement)elementFactory.createExpressionFromText(this.myTargetClassQName, (PsiElement)expression2)));
                newMethodCall = methodCallExpression;
            } else {
                newMethodCall = (PsiMethodCallExpression)expression2.replace((PsiElement)elementFactory.createExpressionFromText(this.myTargetClassQName + "." + expression2.getText(), (PsiElement)expression2));
            }
            if (UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)newMethodCall.getMethodExpression(), false, false, false)) {
                newMethodCall.getMethodExpression().getQualifierExpression().delete();
            }
            return newMethodCall;
        }

        @Override
        public String toString() {
            return "Static method qualifier conversion -> " + this.myTargetClassQName;
        }
    }
}

