/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.psi.PsiClass;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ListCellRendererWrapper;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ClassCellRenderer
extends ListCellRendererWrapper<PsiClass> {
    private final boolean myShowReadOnly;

    public ClassCellRenderer(ListCellRenderer original) {
        this.myShowReadOnly = true;
    }

    public void customize(JList list, PsiClass aClass, int index, boolean selected, boolean hasFocus) {
        if (aClass != null) {
            Icon icon;
            this.setText(ClassCellRenderer.getClassText(aClass));
            int flags = 1;
            if (this.myShowReadOnly) {
                flags |= 2;
            }
            if ((icon = aClass.getIcon(flags)) != null) {
                this.setIcon(icon);
            }
        }
    }

    private static String getClassText(@NotNull PsiClass aClass) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        String name = aClass.getName();
        if (name != null) {
            return name;
        }
        return RefactoringBundle.message((String)"anonymous.class.text");
    }
}

