/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsUtil {
    private ConflictsUtil() {
    }

    @NotNull
    public static PsiElement getContainer(PsiElement place) {
        PsiElement parent = place;
        while (!(parent instanceof PsiMember) || parent instanceof PsiTypeParameter) {
            if (parent instanceof PsiFile) {
                PsiElement host = FileContextUtil.getFileContext((PsiFile)parent);
                if (host == null) {
                    return parent;
                }
                parent = host;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    public static void checkMethodConflicts(@Nullable PsiClass aClass, @Nullable PsiMethod refactoredMethod, PsiMethod prototype, MultiMap<PsiElement, String> conflicts) {
        PsiMethod method2;
        if (prototype == null) {
            return;
        }
        String protoMethodInfo = ConflictsUtil.getMethodPrototypeString(prototype);
        PsiMethod psiMethod = method2 = aClass != null ? aClass.findMethodBySignature(prototype, true) : null;
        if (method2 == null && aClass != null) {
            MethodSignature signature = prototype.getSignature(PsiSubstitutor.EMPTY);
            for (PsiMethod classMethod : aClass.getMethods()) {
                if (!MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)signature, (MethodSignature)classMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                method2 = classMethod;
                protoMethodInfo = "with same erasure";
                break;
            }
        }
        if (method2 != null && method2 != refactoredMethod && !ConflictsUtil.isStaticInterfaceMethods(aClass, refactoredMethod, method2)) {
            if (aClass.equals(method2.getContainingClass())) {
                String classDescr = aClass instanceof PsiAnonymousClass ? RefactoringBundle.message((String)"current.class") : RefactoringUIUtil.getDescription((PsiElement)aClass, false);
                conflicts.putValue((Object)method2, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{protoMethodInfo, classDescr}));
            } else if (JavaPsiFacade.getInstance((Project)method2.getProject()).getResolveHelper().isAccessible((PsiMember)method2, (PsiElement)aClass, null)) {
                String className = CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)method2.getContainingClass()));
                if (PsiUtil.getAccessLevel((PsiModifierList)prototype.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)method2.getModifierList())) {
                    boolean isMethodAbstract = method2.hasModifierProperty("abstract");
                    boolean isMyMethodAbstract = refactoredMethod != null && refactoredMethod.hasModifierProperty("abstract");
                    String conflict = isMethodAbstract != isMyMethodAbstract ? RefactoringBundle.message((String)"method.0.will.implement.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className}) : RefactoringBundle.message((String)"method.0.will.override.a.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className});
                    conflicts.putValue((Object)method2, (Object)conflict);
                } else {
                    conflicts.putValue((Object)method2, (Object)RefactoringBundle.message((String)"method.0.will.hide.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className}));
                }
            }
        }
        if (aClass != null && prototype.hasModifierProperty("private")) {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach(aClass1 -> {
                PsiMethod[] methods;
                for (PsiMethod method1 : methods = aClass1.findMethodsBySignature(prototype, false)) {
                    conflicts.putValue((Object)method1, (Object)("Method " + RefactoringUIUtil.getDescription((PsiElement)method1, true) + " will override method of the base class " + RefactoringUIUtil.getDescription((PsiElement)aClass1, false)));
                }
                return true;
            });
        }
    }

    private static boolean isStaticInterfaceMethods(PsiClass aClass, PsiMethod refactoredMethod, PsiMethod method2) {
        return aClass.isInterface() && method2.hasModifierProperty("static") && refactoredMethod != null && refactoredMethod.hasModifierProperty("static");
    }

    private static String getMethodPrototypeString(PsiMethod prototype) {
        return PsiFormatUtil.formatMethod((PsiMethod)prototype, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
    }

    public static void checkFieldConflicts(@Nullable PsiClass aClass, String newName, MultiMap<PsiElement, String> conflicts) {
        PsiField existingField;
        PsiField psiField = existingField = aClass != null ? aClass.findFieldByName(newName, true) : null;
        if (existingField != null) {
            if (aClass.equals(existingField.getContainingClass())) {
                String className = aClass instanceof PsiAnonymousClass ? RefactoringBundle.message((String)"current.class") : RefactoringUIUtil.getDescription((PsiElement)aClass, false);
                String conflict = RefactoringBundle.message((String)"field.0.is.already.defined.in.the.1", (Object[])new Object[]{existingField.getName(), className});
                conflicts.putValue((Object)existingField, (Object)conflict);
            } else if (!existingField.hasModifierProperty("private")) {
                String fieldInfo = PsiFormatUtil.formatVariable((PsiVariable)existingField, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                String className = RefactoringUIUtil.getDescription((PsiElement)existingField.getContainingClass(), false);
                String descr = RefactoringBundle.message((String)"field.0.will.hide.field.1.of.the.base.class", (Object[])new Object[]{newName, fieldInfo, className});
                conflicts.putValue((Object)existingField, (Object)descr);
            }
        }
    }
}

