/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;

public class FieldConflictsResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.FieldConflictsResolver");
    private final PsiElement myScope;
    private final PsiField myField;
    private final List<PsiReferenceExpression> myReferenceExpressions;
    private PsiClass myQualifyingClass;

    public FieldConflictsResolver(String name, PsiCodeBlock scope) {
        this(name, (PsiElement)scope);
    }

    public FieldConflictsResolver(String name, PsiElement scope) {
        this.myScope = scope;
        if (this.myScope == null) {
            this.myField = null;
            this.myReferenceExpressions = null;
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myScope.getProject());
        PsiVariable oldVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(name, this.myScope);
        PsiField psiField = this.myField = oldVariable instanceof PsiField ? (PsiField)oldVariable : null;
        if (!(oldVariable instanceof PsiField)) {
            this.myReferenceExpressions = null;
            return;
        }
        this.myReferenceExpressions = new ArrayList<PsiReferenceExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)new LocalSearchScope(this.myScope), (boolean)false)) {
            PsiReferenceExpression referenceExpression;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression() != null) continue;
            this.myReferenceExpressions.add(referenceExpression);
        }
        if (this.myField.hasModifierProperty("static")) {
            this.myQualifyingClass = this.myField.getContainingClass();
        }
    }

    public PsiExpression fixInitializer(PsiExpression initializer) {
        if (this.myField == null) {
            return initializer;
        }
        final PsiReferenceExpression[] replacedRef = new PsiReferenceExpression[]{null};
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                if (qualifierExpression2 != null) {
                    qualifierExpression2.accept((PsiElementVisitor)this);
                } else {
                    PsiElement result2 = expression2.resolve();
                    if (expression2.getManager().areElementsEquivalent(result2, (PsiElement)FieldConflictsResolver.this.myField)) {
                        try {
                            replacedRef[0] = RefactoringChangeUtil.qualifyReference(expression2, (PsiMember)FieldConflictsResolver.this.myField, FieldConflictsResolver.this.myQualifyingClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
        if (!initializer.isValid()) {
            return replacedRef[0];
        }
        return initializer;
    }

    public void fix() throws IncorrectOperationException {
        if (this.myField == null) {
            return;
        }
        PsiManager manager = this.myScope.getManager();
        for (PsiReferenceExpression referenceExpression : this.myReferenceExpressions) {
            PsiElement newlyResolved;
            if (!referenceExpression.isValid() || manager.areElementsEquivalent(newlyResolved = referenceExpression.resolve(), (PsiElement)this.myField)) continue;
            RefactoringChangeUtil.qualifyReference(referenceExpression, (PsiMember)this.myField, this.myQualifyingClass);
        }
    }
}

