/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RefactoringUIUtil {
    public static final EditorSettingsProvider SELECT_ALL_ON_FOCUS = new EditorSettingsProvider(){

        @Override
        public void customizeSettings(EditorEx editor) {
            editor.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(Editor editor) {
                    if (LookupManager.getActiveLookup(editor) == null) {
                        editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
                    }
                }

                @Override
                public void focusLost(Editor editor) {
                }
            });
        }
    };

    private RefactoringUIUtil() {
    }

    public static String getDescription(@NotNull PsiElement element, boolean includeParent) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)(includeParent ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT));
    }

    public static void processIncorrectOperation(Project project2, IncorrectOperationException e) {
        int index;
        String message2 = e.getMessage();
        int n = index = message2 != null ? message2.indexOf("java.io.IOException") : -1;
        if (index > 0) {
            message2 = message2.substring(index + "java.io.IOException".length());
        }
        String s = message2;
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)s, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
    }

    public static String calculatePsiElementDescriptionList(PsiElement[] elements) {
        Function presentationFun = element -> UsageViewUtil.getType(element) + " " + DescriptiveNameUtil.getDescriptiveName((PsiElement)element);
        return StringUtil.join((Collection)ContainerUtil.map2LinkedSet(Arrays.asList(elements), (Function)presentationFun), (String)", ");
    }
}

