/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class ExpressionOccurrenceManager
extends BaseOccurrenceManager {
    private final PsiExpression myMainOccurence;
    private final PsiElement myScope;
    private final boolean myMaintainStaticContext;

    public ExpressionOccurrenceManager(PsiExpression mainOccurence, PsiElement scope, OccurrenceFilter filter) {
        this(mainOccurence, scope, filter, false);
    }

    public ExpressionOccurrenceManager(PsiExpression mainOccurence, PsiElement scope, OccurrenceFilter filter, boolean maintainStaticContext) {
        super(filter);
        this.myMainOccurence = mainOccurence;
        this.myScope = scope;
        this.myMaintainStaticContext = maintainStaticContext;
    }

    @Override
    protected PsiExpression[] defaultOccurrences() {
        return new PsiExpression[]{this.myMainOccurence};
    }

    public PsiExpression getMainOccurence() {
        return this.myMainOccurence;
    }

    @Override
    protected PsiExpression[] findOccurrences() {
        if ("null".equals(this.myMainOccurence.getText())) {
            return this.defaultOccurrences();
        }
        if (this.myFilter != null && !this.myFilter.isOK(this.myMainOccurence)) {
            return this.defaultOccurrences();
        }
        PsiExpression[] expressionOccurrences = this.findExpressionOccurrences();
        PsiClass scopeClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myScope, (Class[])new Class[]{PsiClass.class});
        if (this.myMaintainStaticContext && expressionOccurrences.length > 1 && !RefactoringUtil.isInStaticContext((PsiElement)this.myMainOccurence, scopeClass)) {
            ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>(Arrays.asList(expressionOccurrences));
            Iterator<PsiExpression> iterator = expressions2.iterator();
            while (iterator.hasNext()) {
                PsiExpression expression2 = iterator.next();
                if (!RefactoringUtil.isInStaticContext((PsiElement)expression2, scopeClass)) continue;
                iterator.remove();
            }
            return expressions2.toArray(new PsiExpression[expressions2.size()]);
        }
        return expressionOccurrences;
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    public PsiExpression[] findExpressionOccurrences() {
        if (this.myMainOccurence instanceof PsiLiteralExpression && !this.myMainOccurence.isPhysical()) {
            FindManager findManager = FindManager.getInstance((Project)this.getScope().getProject());
            FindModel findModel = findManager.getFindInFileModel().clone();
            findModel.setCaseSensitive(true);
            findModel.setRegularExpressions(false);
            String value2 = StringUtil.stripQuotesAroundValue((String)this.myMainOccurence.getText());
            if (value2.length() > 0) {
                findModel.setStringToFind(value2);
                ArrayList<PsiExpression> results = new ArrayList<PsiExpression>();
                PsiFile file2 = this.getScope().getContainingFile();
                String text = this.getScope().getText();
                int offset = this.getScope().getTextRange().getStartOffset();
                FindResult result2 = findManager.findString((CharSequence)text, 0, findModel);
                HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
                while (result2.isStringFound()) {
                    PsiExpression expression2;
                    int startOffset = offset + result2.getStartOffset();
                    int endOffset = result2.getEndOffset();
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(startOffset), PsiLiteralExpression.class);
                    if (literalExpression != null && !literals.contains(literalExpression) && (expression2 = IntroduceVariableBase.getSelectedExpression(file2.getProject(), file2, startOffset, offset + endOffset)) != null && IntroduceVariableBase.getErrorMessage(expression2) == null) {
                        results.add(expression2);
                        literals.add(literalExpression);
                    }
                    result2 = findManager.findString((CharSequence)text, endOffset, findModel);
                }
                return results.toArray(new PsiExpression[results.size()]);
            }
        }
        return CodeInsightUtil.findExpressionOccurrences(this.myScope, this.myMainOccurence);
    }
}

