/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class UnwrapCall
extends FixableUsageInfo {
    private final PsiCallExpression myCall;
    private final String myUnwrapMethod;

    public UnwrapCall(@NotNull PsiCallExpression call, @NotNull String unwrapMethod) {
        super((PsiElement)call);
        this.myCall = call;
        this.myUnwrapMethod = unwrapMethod;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression = this.myCall.getText() + '.' + this.myUnwrapMethod + "()";
        MutationUtils.replaceExpression(newExpression, (PsiExpression)this.myCall);
    }
}

