/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConnectionCredentialsWrapper {
    private UserDataHolderBase myCredentialsTypeHolder = new UserDataHolderBase();

    public <C> void setCredentials(Key<C> key2, C credentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(key2, credentials);
    }

    public Object getConnectionKey() {
        return this.getCredentials();
    }

    public void save(Element rootElement) {
        this.getTypeHandler().save(rootElement);
    }

    public static IllegalStateException unknownConnectionType() {
        return new IllegalStateException("Unknown connection type");
    }

    public void copyTo(RemoteConnectionCredentialsWrapper copy) {
        copy.myCredentialsTypeHolder = new UserDataHolderBase();
        Pair<Object, CredentialsType> credentialsAndProvider = this.getCredentialsAndType();
        ((CredentialsType)credentialsAndProvider.getSecond()).putCredentials(copy.myCredentialsTypeHolder, credentialsAndProvider.getFirst());
    }

    @NotNull
    public String getId() {
        return this.getTypeHandler().getId();
    }

    public RemoteCredentialsHandler getTypeHandler() {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        return ((CredentialsType)credentialsAndType.getSecond()).getHandler(credentialsAndType.getFirst());
    }

    public CredentialsType getRemoteConnectionType() {
        return (CredentialsType)this.getCredentialsAndType().getSecond();
    }

    public Object getCredentials() {
        return this.getCredentialsAndType().getFirst();
    }

    private Pair<Object, CredentialsType> getCredentialsAndType() {
        for (CredentialsType type2 : CredentialsManager.getInstance().getAllTypes()) {
            Object credentials = type2.getCredentials(this.myCredentialsTypeHolder);
            if (credentials == null) continue;
            return Pair.create(credentials, (Object)type2);
        }
        UnknownCredentialsHolder credentials = CredentialsType.UNKNOWN.getCredentials(this.myCredentialsTypeHolder);
        if (credentials != null) {
            return Pair.create((Object)credentials, CredentialsType.UNKNOWN);
        }
        throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    public void switchType(CredentialsCase ... cases) {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        CredentialsType type2 = (CredentialsType)credentialsAndType.getSecond();
        for (CredentialsCase credentialsCase : cases) {
            if (credentialsCase.getType() != type2) continue;
            credentialsCase.process(credentialsAndType.getFirst());
            return;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteConnectionCredentialsWrapper) {
            RemoteConnectionCredentialsWrapper w = (RemoteConnectionCredentialsWrapper)obj;
            try {
                Object credentials = this.getCredentials();
                Object counterCredentials = w.getCredentials();
                return credentials.equals(counterCredentials);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return false;
    }

    public String getPresentableDetails(String interpreterPath) {
        return this.getTypeHandler().getPresentableDetails(interpreterPath);
    }
}

