/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsHandler
extends RemoteCredentialsHandlerBase<WebDeploymentCredentialsHolder> {
    public static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";

    public WebDeploymentCredentialsHandler(WebDeploymentCredentialsHolder credentials) {
        super(credentials);
    }

    @Override
    public String getId() {
        return this.constructSftpCredentialsFullPath();
    }

    @Override
    public void save(@NotNull Element rootElement) {
        ((WebDeploymentCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    @Override
    public String getPresentableDetails(String interpreterPath) {
        return "(" + this.constructSftpCredentialsFullPath() + interpreterPath + ")";
    }

    @Override
    public void load(@Nullable Element rootElement) {
        WebDeploymentCredentialsHolder credentials = (WebDeploymentCredentialsHolder)this.getCredentials();
        if (rootElement != null) {
            credentials.load(rootElement);
        } else {
            credentials.setWebServerConfigId("");
            credentials.setWebServerConfigName("Invalid");
        }
    }

    @NotNull
    private String constructSftpCredentialsFullPath() {
        RemoteCredentials cred = ((WebDeploymentCredentialsHolder)this.getCredentials()).getSshCredentials();
        return SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
    }
}

