/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class ServerTaskExecutorImpl
implements ServerTaskExecutor {
    private static final Logger LOG = Logger.getInstance(ServerTaskExecutorImpl.class);
    private final ExecutorService myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ServerTaskExecutorImpl pool");

    public void execute(@NotNull Runnable command) {
        this.myTaskExecutor.execute(command);
    }

    public void submit(@NotNull Runnable command) {
        this.execute(command);
    }

    public void submit(@NotNull ThrowableRunnable<?> command, @NotNull RemoteOperationCallback callback) {
        this.execute(() -> {
            try {
                command.run();
            }
            catch (Throwable e) {
                LOG.info(e);
                callback.errorOccurred(e.getMessage());
            }
        });
    }
}

