/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDeploymentImpl<D extends DeploymentConfiguration>
extends DeploymentImpl<D> {
    private final ServerRuntimeInstance<D> myServerInstance;
    private DeploymentImpl myRemoteDeployment;

    public LocalDeploymentImpl(@NotNull ServerRuntimeInstance<D> instance, @NotNull ServerConnectionImpl<D> connection, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @NotNull DeploymentTask<D> deploymentTask) {
        super(connection, instance.getDeploymentName(deploymentTask.getSource(), deploymentTask.getConfiguration()), status, statusText, runtime, deploymentTask);
        this.myServerInstance = instance;
    }

    public void setRemoteDeployment(DeploymentImpl remoteDeployment) {
        this.myRemoteDeployment = remoteDeployment;
        String presentableName = null;
        if (remoteDeployment != null) {
            DeploymentRuntime deploymentRuntime = remoteDeployment.getRuntime();
            DeploymentTask task = this.getDeploymentTask();
            if (deploymentRuntime != null) {
                presentableName = this.myServerInstance.getRuntimeDeploymentName(deploymentRuntime, task.getSource(), task.getConfiguration());
            }
        }
        this.setPresentableName(presentableName);
    }

    private boolean isLocalState() {
        return this.myRemoteDeployment == null || super.getStatus().isTransition();
    }

    @Override
    @NotNull
    public DeploymentStatus getStatus() {
        return this.isLocalState() ? super.getStatus() : this.myRemoteDeployment.getStatus();
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.isLocalState() ? super.getStatusText() : this.myRemoteDeployment.getStatusText();
    }

    @Override
    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        boolean result2 = super.changeState(oldStatus, newStatus, statusText, runtime);
        if (result2 && this.myRemoteDeployment != null) {
            this.myRemoteDeployment.changeState(this.myRemoteDeployment.getStatus(), newStatus, statusText, this.myRemoteDeployment.getRuntime());
        }
        return result2;
    }
}

