/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class DeploymentLogManagerImpl
implements DeploymentLogManager {
    private final LoggingHandlerImpl myMainLoggingHandler;
    private final Project myProject;
    private final List<LoggingHandlerBase> myAdditionalLoggingHandlers = new ArrayList<LoggingHandlerBase>();
    private final Runnable myChangeListener;
    private final AtomicBoolean myLogsDisposed = new AtomicBoolean(false);
    private final Disposable myLogsDisposable;
    private boolean myMainHandlerVisible = false;

    public DeploymentLogManagerImpl(@NotNull Project project2, @NotNull Runnable changeListener) {
        this.myProject = project2;
        this.myChangeListener = changeListener;
        this.myMainLoggingHandler = new LoggingHandlerImpl.Colored(null, project2);
        this.myLogsDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)this.myMainLoggingHandler);
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentLogManagerImpl.this.disposeLogs();
            }
        });
    }

    public DeploymentLogManagerImpl withMainHandlerVisible(boolean mainHandlerVisible) {
        this.myMainHandlerVisible = mainHandlerVisible;
        return this;
    }

    public boolean isMainHandlerVisible() {
        return this.myMainHandlerVisible;
    }

    @NotNull
    public LoggingHandlerImpl getMainLoggingHandler() {
        return this.myMainLoggingHandler;
    }

    @NotNull
    public LoggingHandler addAdditionalLog(@NotNull String presentableName) {
        LoggingHandlerImpl.Colored handler2 = new LoggingHandlerImpl.Colored(presentableName, this.myProject);
        this.addAdditionalLoggingHandler(handler2);
        return handler2;
    }

    public TerminalHandler addTerminal(@NotNull String presentableName, InputStream terminalOutput, OutputStream terminalInput) {
        TerminalHandlerBase handler2 = CloudTerminalProvider.getInstance().createTerminal(presentableName, this.myProject, terminalOutput, terminalInput);
        this.addAdditionalLoggingHandler(handler2);
        return handler2;
    }

    public boolean isTtySupported() {
        return CloudTerminalProvider.getInstance().isTtySupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalLoggingHandler(LoggingHandlerBase loggingHandler) {
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)loggingHandler);
        List<LoggingHandlerBase> list = this.myAdditionalLoggingHandlers;
        synchronized (list) {
            this.myAdditionalLoggingHandlers.add(loggingHandler);
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LoggingHandlerBase> getAdditionalLoggingHandlers() {
        ArrayList<LoggingHandlerBase> result2;
        List<LoggingHandlerBase> list = this.myAdditionalLoggingHandlers;
        synchronized (list) {
            result2 = new ArrayList<LoggingHandlerBase>(this.myAdditionalLoggingHandlers);
        }
        return result2;
    }

    public void disposeLogs() {
        if (!this.myLogsDisposed.getAndSet(true)) {
            Disposer.dispose((Disposable)this.myLogsDisposable);
        }
    }
}

