/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LoggingHandlerImpl
extends LoggingHandlerBase
implements LoggingHandler {
    private final ConsoleView myConsole;

    public LoggingHandlerImpl(String presentableName, @NotNull Project project2) {
        super(presentableName);
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project2).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    @Override
    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    public void print(@NotNull String s) {
        this.printText(s, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    protected void printText(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        this.myConsole.print(text, contentType);
    }

    public void printHyperlink(@NotNull String url) {
        this.printHyperlink(url, (HyperlinkInfo)new BrowserHyperlinkInfo(url));
    }

    public void printHyperlink(@NotNull String text, HyperlinkInfo info) {
        this.myConsole.printHyperlink(text, info);
    }

    public void printlnSystemMessage(@NotNull String s) {
        this.printText(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void attachToProcess(@NotNull ProcessHandler handler2) {
        this.myConsole.attachToProcess(handler2);
    }

    public void clear() {
        this.myConsole.clear();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public static class Colored
    extends LoggingHandlerImpl {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        public Colored(String presentableName, @NotNull Project project2) {
            super(presentableName, project2);
        }

        @Override
        public void print(@NotNull String s) {
            this.myAnsiEscapeDecoder.escapeText(s, ProcessOutputTypes.STDOUT, this::printTextWithOutputKey);
        }

        private void printTextWithOutputKey(@NotNull String text, Key outputType) {
            this.printText(text, ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }
    }
}

