/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class SliceLeafValueRootNode
extends SliceNode
implements MyColoredTreeCellRenderer {
    final List<SliceNode> myCachedChildren;

    SliceLeafValueRootNode(@NotNull Project project2, @NotNull PsiElement leafExpression, @NotNull SliceNode root, @NotNull List<SliceNode> children2, @NotNull SliceAnalysisParams params) {
        super(project2, JavaSliceUsage.createRootUsage(leafExpression, params), root.targetEqualUsages);
        this.myCachedChildren = children2;
    }

    @NotNull
    public Collection<SliceNode> getChildren() {
        return this.myCachedChildren;
    }

    @Override
    protected void update(PresentationData presentation) {
    }

    @Override
    public String toString() {
        PsiElement element;
        Usage myLeafExpression = (Usage)this.getValue();
        String text = myLeafExpression instanceof UsageInfo2UsageAdapter ? ((element = ((UsageInfo2UsageAdapter)myLeafExpression).getUsageInfo().getElement()) == null ? "" : element.getText()) : "Other";
        return "Value: " + text;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Usage usage = (Usage)this.getValue();
        renderer.append("Value: ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (usage instanceof UsageInfo2UsageAdapter) {
            PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
            if (element == null) {
                renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
            } else {
                SliceLeafValueRootNode.appendElementText((UsageInfo2UsageAdapter)usage, element, renderer);
            }
        } else {
            renderer.append("Other", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static void appendElementText(@NotNull UsageInfo2UsageAdapter usage, @NotNull PsiElement element, @NotNull SliceUsageCellRendererBase renderer) {
        PsiFile file2 = element.getContainingFile();
        ArrayList result2 = new ArrayList();
        ChunkExtractor.getExtractor((PsiFile)element.getContainingFile()).createTextChunks(usage, (CharSequence)file2.getText(), element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset(), false, result2);
        for (TextChunk chunk : result2) {
            renderer.append(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }
}

