/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceRootNode
extends SliceNode {
    private final SliceUsage myRootUsage;

    public SliceRootNode(@NotNull Project project2, @NotNull DuplicateMap targetEqualUsages, @NotNull SliceUsage rootUsage) {
        super(project2, LanguageSlicing.getProvider((PsiElement)rootUsage.getElement().getContainingFile()).createRootUsage((PsiElement)rootUsage.getElement().getContainingFile(), rootUsage.params), targetEqualUsages);
        this.myRootUsage = rootUsage;
    }

    private void switchToAllLeavesTogether(SliceUsage rootUsage) {
        SliceNode node = new SliceNode(this.getProject(), rootUsage, this.targetEqualUsages);
        this.myCachedChildren = Collections.singletonList(node);
    }

    @Override
    @NotNull
    SliceRootNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceRootNode newNode = new SliceRootNode(this.getProject(), new DuplicateMap(), newUsage);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        return newNode;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.switchToAllLeavesTogether(this.myRootUsage);
        }
        return this.myCachedChildren;
    }

    @Override
    @NotNull
    public List<? extends AbstractTreeNode> getChildrenUnderProgress(@NotNull ProgressIndicator progress) {
        return (List)this.getChildren();
    }

    @Override
    protected void update(PresentationData presentation) {
        if (presentation != null) {
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    }

    @NotNull
    SliceUsage getRootUsage() {
        return this.myRootUsage;
    }
}

