/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInspection.SuppressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spellchecker.DocCommentTokenizer;
import com.intellij.spellchecker.LiteralExpressionTokenizer;
import com.intellij.spellchecker.MethodNameTokenizerJava;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final MethodNameTokenizerJava myMethodNameTokenizer = new MethodNameTokenizerJava();
    private final DocCommentTokenizer myDocCommentTokenizer = new DocCommentTokenizer();
    private final LiteralExpressionTokenizer myLiteralExpressionTokenizer = new LiteralExpressionTokenizer();
    private final NamedElementTokenizer myNamedElementTokenizer = new NamedElementTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiMethod) {
            return this.myMethodNameTokenizer;
        }
        if (element instanceof PsiDocComment) {
            return this.myDocCommentTokenizer;
        }
        if (element instanceof PsiLiteralExpression) {
            if (SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)((PsiLiteralExpression)element))) {
                return EMPTY_TOKENIZER;
            }
            return this.myLiteralExpressionTokenizer;
        }
        if (element instanceof PsiNamedElement) {
            return this.myNamedElementTokenizer;
        }
        return super.getTokenizer(element);
    }
}

