/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiTypeTokenizer
extends Tokenizer<PsiTypeElement> {
    @Override
    public void tokenize(@NotNull PsiTypeElement element, TokenConsumer consumer2) {
        String elementText;
        boolean isInSource;
        PsiType type2 = element.getType();
        if (type2 instanceof PsiDisjunctionType) {
            this.tokenizeComplexType(element, consumer2);
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.getContainingFile() == null || psiClass.getContainingFile().getVirtualFile() == null) {
            return;
        }
        String name = psiClass.getName();
        if (name == null) {
            return;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        boolean bl = isInSource = virtualFile != null && fileIndex.isInContent(virtualFile);
        if (isInSource && (elementText = element.getText()).contains(name)) {
            consumer2.consumeToken((PsiElement)element, elementText, true, 0, PsiTypeTokenizer.getRangeToCheck(elementText, name), IdentifierSplitter.getInstance());
        }
    }

    private void tokenizeComplexType(PsiTypeElement element, TokenConsumer consumer2) {
        List subTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, PsiTypeElement.class);
        for (PsiTypeElement subType : subTypes) {
            this.tokenize(subType, consumer2);
        }
    }

    @NotNull
    private static TextRange getRangeToCheck(@NotNull String text, @NotNull String name) {
        int i2 = text.indexOf(name);
        return new TextRange(i2, i2 + name.length());
    }
}

