/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.spellchecker.BaseSuggestionProvider;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerFactory;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.AggregatedDictionaryState;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.SpellCheckerManager");
    private static final int MAX_SUGGESTIONS_THRESHOLD = 5;
    private static final int MAX_METRICS = 1;
    private final Project project;
    private SpellCheckerEngine spellChecker;
    private EditableDictionary userDictionary;
    private final SuggestionProvider suggestionProvider = new BaseSuggestionProvider(this);
    private final SpellCheckerSettings settings;

    public static SpellCheckerManager getInstance(Project project2) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project2, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project2, SpellCheckerSettings settings) {
        this.project = project2;
        this.settings = settings;
        this.fullConfigurationReload();
    }

    public void fullConfigurationReload() {
        this.spellChecker = SpellCheckerFactory.create(this.project);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        for (BundledDictionaryProvider provider2 : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider2.getBundledDictionaries()) {
                boolean dictionaryShouldBeLoad = this.settings == null || !this.settings.getBundledDisabledDictionariesPaths().contains(dictionary);
                boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                Class<?> loaderClass = provider2.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)s -> {
                    boolean dictionaryShouldBeLoad = !disabledDictionaries.contains(s);
                    boolean dictionaryIsLoad = this.spellChecker.isDictionaryLoad((String)s);
                    if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                        this.spellChecker.removeDictionary((String)s);
                    } else if (!dictionaryIsLoad && dictionaryShouldBeLoad) {
                        this.spellChecker.loadDictionary(new FileLoader((String)s, (String)s));
                    }
                }));
            }
        }
        if (!ContainerUtil.isEmpty(removedDictionaries)) {
            for (String name : removedDictionaries) {
                this.spellChecker.removeDictionary(name);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    public EditableDictionary getUserDictionary() {
        return this.userDictionary;
    }

    private void fillEngineDictionary() {
        this.spellChecker.reset();
        SmartList loaders = new SmartList();
        for (BundledDictionaryProvider provider2 : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            for (String dictionary : provider2.getBundledDictionaries()) {
                if (this.settings != null && this.settings.getBundledDisabledDictionariesPaths().contains(dictionary)) continue;
                Class<?> loaderClass = provider2.getClass();
                InputStream stream = loaderClass.getResourceAsStream(dictionary);
                if (stream != null) {
                    loaders.add(new StreamLoader(stream, dictionary));
                    continue;
                }
                LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
            }
        }
        if (this.settings != null && this.settings.getDictionaryFoldersPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String folder : this.settings.getDictionaryFoldersPaths()) {
                SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)arg_0 -> SpellCheckerManager.lambda$fillEngineDictionary$1(disabledDictionaries, (List)loaders, arg_0)));
            }
        }
        for (Loader loader : loaders) {
            this.spellChecker.loadDictionary(loader);
        }
        this.userDictionary = ((AggregatedDictionaryState)ServiceManager.getService((Project)this.project, AggregatedDictionaryState.class)).getDictionary();
        this.spellChecker.addModifiableDictionary(this.userDictionary);
    }

    public boolean hasProblem(@NotNull String word) {
        return !this.spellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project2) {
        String transformed = this.spellChecker.getTransformation().transform(word);
        if (transformed != null) {
            this.userDictionary.addToDictionary(transformed);
            PsiModificationTrackerImpl modificationTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project2).getModificationTracker();
            modificationTracker.incCounter();
        }
    }

    public void updateUserDictionary(@Nullable Collection<String> words) {
        this.userDictionary.replaceAll(words);
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider2 : (BundledDictionaryProvider[])Extensions.getExtensions(BundledDictionaryProvider.EP_NAME)) {
            ContainerUtil.addAll(dictionaries, (Object[])provider2.getBundledDictionaries());
        }
        return dictionaries;
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        return this.suggestionProvider.getSuggestions(text);
    }

    @NotNull
    protected List<String> getRawSuggestions(@NotNull String word) {
        ArrayList<String> suggestions;
        if (!this.spellChecker.isCorrect(word) && !(suggestions = this.spellChecker.getSuggestions(word, 5, 1)).isEmpty()) {
            if (Strings.isCapitalized(word)) {
                Strings.capitalize(suggestions);
            } else if (Strings.isUpperCase(word)) {
                Strings.upperCase(suggestions);
            }
            LinkedHashSet<String> unique = new LinkedHashSet<String>(suggestions);
            return unique.size() < suggestions.size() ? new ArrayList<String>(unique) : suggestions;
        }
        return Collections.emptyList();
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            for (Project project1 : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (!project1.isInitialized() || !project1.isOpen() || project1.isDefault()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project1).restart();
            }
        });
    }

    private static /* synthetic */ void lambda$fillEngineDictionary$1(Set disabledDictionaries, List loaders, String s) {
        if (!disabledDictionaries.contains(s)) {
            loaders.add(new FileLoader(s, s));
        }
    }
}

