/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.UnitBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Encoder {
    private final Alphabet alphabet;
    private static final int offset = 0;
    static final UnitBitSet WORD_OF_ENTIRELY_UNKNOWN_LETTERS = new UnitBitSet(new byte[1], new Alphabet());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.compress");

    public Encoder() {
        this(new Alphabet());
    }

    public Encoder(@NotNull Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Nullable
    public UnitBitSet encode(@NotNull CharSequence letters, boolean force) {
        if (64 <= letters.length() + 0) {
            return null;
        }
        int unknownLetters = 0;
        byte[] indices2 = new byte[letters.length()];
        for (int i2 = 0; i2 < letters.length(); ++i2) {
            char letter = letters.charAt(i2);
            int index = this.alphabet.getIndex(letter, force);
            if (index < 0) {
                ++unknownLetters;
                continue;
            }
            indices2[i2] = (byte)index;
        }
        if (unknownLetters == letters.length()) {
            return WORD_OF_ENTIRELY_UNKNOWN_LETTERS;
        }
        if (unknownLetters > 0) {
            return null;
        }
        return new UnitBitSet(indices2, this.alphabet);
    }

    @NotNull
    public String decode(@NotNull byte[] compressed) {
        return UnitBitSet.decode(compressed, this.alphabet);
    }

    public int getFirstLetterIndex(byte firstPackedByte) {
        return UnitBitSet.getFirstLetterIndex(firstPackedByte, this.alphabet);
    }
}

