/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class UnitBitSet {
    static final int MAX_CHARS_IN_WORD = 64;
    static final int MAX_UNIT_VALUE = 255;
    final byte[] b;
    private final Alphabet alpha;

    UnitBitSet(@NotNull byte[] indices2, @NotNull Alphabet alphabet) {
        this.b = indices2;
        this.alpha = alphabet;
    }

    int getUnitValue(int number) {
        int r = this.b[number] & 0xFF;
        assert (r >= 0 && r <= 255) : "invalid unit value";
        return r;
    }

    void setUnitValue(int number, int value2) {
        assert (value2 >= 0) : "unit value is negative" + value2;
        assert (value2 <= 255) : "unit value is too big";
        this.b[number] = (byte)value2;
    }

    public boolean equals(Object obj) {
        return obj instanceof UnitBitSet && Arrays.equals(this.b, ((UnitBitSet)obj).b);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (byte aB : this.b) {
            s.append(Integer.toHexString(aB & 0xFF));
        }
        return s.toString();
    }

    @NotNull
    public byte[] pack() {
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(this.alpha.getLastIndexUsed());
        assert (meaningfulBits <= 8 && meaningfulBits >= 1) : meaningfulBits + ": " + this.alpha;
        byte[] result2 = new byte[(this.b.length * meaningfulBits + 7) / 8];
        int byteNumber = 0;
        int bitOffset = 0;
        for (byte index : this.b) {
            int bitsToChip = Math.min(8 - bitOffset, meaningfulBits);
            int n = byteNumber++;
            result2[n] = (byte)(result2[n] | (index & (1 << bitsToChip) - 1) << bitOffset);
            int bitsLeft = meaningfulBits - bitsToChip;
            if (bitsLeft > 0) {
                int n2 = byteNumber;
                result2[n2] = (byte)(result2[n2] | index >> bitsToChip & (1 << bitsLeft) - 1);
                bitOffset = bitsLeft;
                continue;
            }
            bitOffset += bitsToChip;
        }
        return result2;
    }

    @NotNull
    public static String decode(@NotNull byte[] packed, @NotNull Alphabet alphabet) {
        int index;
        char letter;
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8) : alphabet;
        StringBuilder result2 = new StringBuilder(packed.length * 8 / meaningfulBits);
        int curByte = packed[0];
        int byteIndex = 0;
        int bitOffset = 0;
        while (byteIndex < packed.length && (letter = alphabet.getLetter(index = curByte & (1 << meaningfulBits) - 1)) != '\u0000') {
            result2.append(letter);
            curByte >>>= meaningfulBits;
            assert ((bitOffset += meaningfulBits) <= 8) : alphabet;
            if (bitOffset + meaningfulBits <= 8) continue;
            if (++byteIndex == packed.length) break;
            int leftOverBits = 8 - bitOffset;
            curByte = packed[byteIndex] << leftOverBits | curByte & (1 << leftOverBits) - 1;
            bitOffset = -leftOverBits;
        }
        return result2.toString();
    }

    static int getFirstLetterIndex(byte firstPackedByte, @NotNull Alphabet alphabet) {
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8) : alphabet;
        int index = firstPackedByte & (1 << meaningfulBits) - 1;
        return index;
    }
}

