/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDictionary
implements EditableDictionary {
    @NonNls
    private static final String DEFAULT_CURRENT_USER_NAME = "default.user";
    private static final String DEFAULT_PROJECT_DICTIONARY_NAME = "project";
    private String activeName;
    private Set<EditableDictionary> dictionaries;

    public ProjectDictionary() {
    }

    public ProjectDictionary(@NotNull Set<EditableDictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return DEFAULT_PROJECT_DICTIONARY_NAME;
    }

    public void setActiveName(String name) {
        this.activeName = name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (this.dictionaries == null) {
            return false;
        }
        int errors = 0;
        for (Dictionary dictionary : this.dictionaries) {
            Boolean contains = dictionary.contains(word);
            if (contains == null) {
                ++errors;
                continue;
            }
            if (!contains.booleanValue()) continue;
            return true;
        }
        if (errors == this.dictionaries.size()) {
            return null;
        }
        return false;
    }

    @Override
    public void addToDictionary(String word) {
        this.getActiveDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        this.getActiveDictionary().removeFromDictionary(word);
    }

    @NotNull
    private EditableDictionary getActiveDictionary() {
        return this.ensureCurrentUserDictionary();
    }

    @NotNull
    private EditableDictionary ensureCurrentUserDictionary() {
        EditableDictionary result2;
        if (this.activeName == null) {
            this.activeName = DEFAULT_CURRENT_USER_NAME;
        }
        if ((result2 = this.getDictionaryByName(this.activeName)) == null) {
            result2 = new UserDictionary(this.activeName);
            if (this.dictionaries == null) {
                this.dictionaries = new THashSet();
            }
            this.dictionaries.add(result2);
        }
        return result2;
    }

    @Nullable
    private EditableDictionary getDictionaryByName(@NotNull String name) {
        if (this.dictionaries == null) {
            return null;
        }
        EditableDictionary result2 = null;
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.getName().equals(name)) continue;
            result2 = dictionary;
            break;
        }
        return result2;
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.getActiveDictionary().replaceAll(words);
    }

    @Override
    public void clear() {
        this.getActiveDictionary().clear();
    }

    @Override
    @Nullable
    public Set<String> getWords() {
        if (this.dictionaries == null) {
            return null;
        }
        THashSet words = new THashSet();
        for (Dictionary dictionary : this.dictionaries) {
            Set<String> otherWords = dictionary.getWords();
            if (otherWords == null) continue;
            words.addAll(otherWords);
        }
        return words;
    }

    @Override
    public int size() {
        int result2 = 0;
        for (Dictionary dictionary : this.dictionaries) {
            result2 += dictionary.size();
        }
        return result2;
    }

    @Override
    public void traverse(@NotNull Consumer<String> consumer2) {
        if (this.dictionaries == null) {
            return;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            dictionary.traverse(consumer2);
        }
    }

    @Override
    @Nullable
    public Set<String> getEditableWords() {
        return this.getActiveDictionary().getWords();
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getActiveDictionary().addToDictionary(words);
    }

    public Set<EditableDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDictionary that = (ProjectDictionary)o;
        if (this.activeName != null ? !this.activeName.equals(that.activeName) : that.activeName != null) {
            return false;
        }
        return !(this.dictionaries != null ? !this.dictionaries.equals(that.dictionaries) : that.dictionaries != null);
    }

    public int hashCode() {
        int result2 = this.activeName != null ? this.activeName.hashCode() : 0;
        result2 = 31 * result2 + (this.dictionaries != null ? this.dictionaries.hashCode() : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return "ProjectDictionary{activeName='" + this.activeName + '\'' + ", dictionaries=" + this.dictionaries + '}';
    }
}

