/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierSplitter
extends BaseSplitter {
    private static final IdentifierSplitter INSTANCE = new IdentifierSplitter();
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\b\\p{L}*'?\\p{L}*");
    @NonNls
    private static final Pattern WORD_IN_QUOTES = Pattern.compile("'([^']*)'");

    public static IdentifierSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer2) {
        if (text == null || range.getLength() < 1 || range.getStartOffset() < 0) {
            return;
        }
        List<TextRange> extracted = IdentifierSplitter.excludeByPattern(text, range, WORD_IN_QUOTES, 1);
        for (TextRange textRange : extracted) {
            List<TextRange> words = IdentifierSplitter.splitByCase(text, textRange);
            if (words.size() == 0) continue;
            if (words.size() == 1) {
                IdentifierSplitter.addWord(consumer2, false, words.get(0));
                continue;
            }
            boolean isCapitalized = Strings.isCapitalized(text, words.get(0));
            boolean containsShortWord = IdentifierSplitter.containsShortWord(words);
            if (isCapitalized && containsShortWord) continue;
            boolean isAllWordsAreUpperCased = IdentifierSplitter.isAllWordsAreUpperCased(text, words);
            for (TextRange word : words) {
                boolean flag;
                boolean uc = Strings.isUpperCased(text, word);
                boolean bl = flag = uc && !isAllWordsAreUpperCased;
                Matcher matcher = WORD.matcher(text.substring(word.getStartOffset(), word.getEndOffset()));
                if (!matcher.find()) continue;
                TextRange found = IdentifierSplitter.matcherRange(word, matcher);
                IdentifierSplitter.addWord(consumer2, flag, found);
            }
        }
    }

    @NotNull
    private static List<TextRange> splitByCase(@NotNull String text, @NotNull TextRange range) {
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        int i2 = range.getStartOffset();
        int s = -1;
        int prevType = 25;
        while (i2 < range.getEndOffset()) {
            char ch = text.charAt(i2);
            if (ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff' || ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\uff00' && ch <= '\uffef') {
                if (s >= 0) {
                    IdentifierSplitter.add(text, result2, i2, s);
                    s = -1;
                }
                prevType = 25;
                ++i2;
                continue;
            }
            int type2 = Character.getType(ch);
            if (type2 == 2 || type2 == 1 || type2 == 3 || type2 == 5 || type2 == 4 || type2 == 24) {
                if (s < 0) {
                    s = i2;
                } else if (s >= 0 && type2 == 1 && prevType == 2) {
                    IdentifierSplitter.add(text, result2, i2, s);
                    s = i2;
                } else if (i2 - s >= 1 && type2 == 2 && prevType == 1) {
                    IdentifierSplitter.add(text, result2, i2 - 1, s);
                    s = i2 - 1;
                }
            } else if (s >= 0) {
                IdentifierSplitter.add(text, result2, i2, s);
                s = -1;
            }
            prevType = type2;
            ++i2;
        }
        if (s >= 0) {
            IdentifierSplitter.add(text, result2, i2, s);
        }
        return result2;
    }

    private static void add(String text, List<TextRange> result2, int i2, int s) {
        if (i2 - s > 3) {
            TextRange textRange = new TextRange(s, i2);
            result2.add(textRange);
        }
    }
}

