/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.WordSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextSplitter
extends BaseSplitter {
    private static final TextSplitter INSTANCE = new TextSplitter();
    private static final Pattern EXTENDED_WORD_AND_SPECIAL = Pattern.compile("(&[^;]+;)|(([#]|0x[0-9]*)?\\p{L}+'?\\p{L}[_\\p{L}]*)");

    public static TextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer2) {
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        this.doSplit(text, range, consumer2);
    }

    protected void doSplit(@NotNull String text, @NotNull TextRange range, Consumer<TextRange> consumer2) {
        WordSplitter ws = WordSplitter.getInstance();
        Matcher matcher = EXTENDED_WORD_AND_SPECIAL.matcher(text);
        matcher.region(range.getStartOffset(), range.getEndOffset());
        while (matcher.find()) {
            TextRange found = new TextRange(matcher.start(), matcher.end());
            ws.split(text, found, consumer2);
        }
    }
}

