/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public ChangeTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        return SpellCheckerBundle.message("change.to", new Object[0]);
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.FIRST;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)element);
        if (editor == null) {
            return;
        }
        TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        String word = editor.getSelectionModel().getSelectedText();
        if (word == null || StringUtil.isEmpty((String)word)) {
            return;
        }
        ArrayList<LookupElementBuilder> lookupItems = new ArrayList<LookupElementBuilder>();
        for (String variant : this.getSuggestions(project2)) {
            lookupItems.add(LookupElementBuilder.create((String)variant));
        }
        LookupElement[] items = new LookupElement[lookupItems.size()];
        items = lookupItems.toArray(items);
        LookupManager lookupManager = LookupManager.getInstance(project2);
        lookupManager.showLookup(editor, items);
    }
}

