/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.ShowSuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends ShowSuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        Object[] extensions;
        for (Object extension : extensions = Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME)) {
            if (!(extension instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension);
        }
        return null;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.FIRST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        DictionarySuggestionProvider provider2 = RenameTo.findProvider();
        if (provider2 != null) {
            provider2.setActive(true);
        }
        Editor editor = RenameTo.getEditorFromFocus();
        HashMap map2 = new HashMap();
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (editor == null) {
            editor = InjectedLanguageUtil.openEditorFor(containingFile, project2);
        }
        if (editor == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            map2.put((Object)CommonDataKeys.EDITOR.getName(), (Object)editor);
            map2.put((Object)CommonDataKeys.PSI_ELEMENT.getName(), (Object)psiElement);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            map2.put((Object)CommonDataKeys.PSI_ELEMENT.getName(), new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret()));
        }
        Boolean selectAll = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        try {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
            DataContext dataContext = SimpleDataContext.getSimpleContext((Map<String, Object>)map2, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            RenameElementAction action = new RenameElementAction();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)dataContext);
            action.actionPerformed(event);
            if (provider2 != null) {
                provider2.setActive(false);
            }
        }
        finally {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static Editor getEditorFromFocus() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c instanceof EditorComponentImpl) {
            return ((EditorComponentImpl)c).getEditor();
        }
        return null;
    }
}

