/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.dictionary.AggregatedDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import org.jetbrains.annotations.NotNull;

public class AggregatedDictionaryState {
    private AggregatedDictionary dictionary;

    public AggregatedDictionaryState(@NotNull Project project2) {
        CachedDictionaryState cachedDictionaryState = (CachedDictionaryState)ServiceManager.getService(CachedDictionaryState.class);
        ProjectDictionaryState projectDictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)project2, ProjectDictionaryState.class);
        String currentUser = System.getProperty("user.name");
        ProjectDictionary projectDictionary = projectDictionaryState.getProjectDictionary();
        projectDictionary.setActiveName(currentUser);
        if (cachedDictionaryState.getDictionary() == null) {
            cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.dictionary = new AggregatedDictionary(projectDictionary, cachedDictionaryState.getDictionary());
        cachedDictionaryState.setDictionary(this.dictionary.getCachedDictionary());
        projectDictionaryState.setProjectDictionary(this.dictionary.getProjectDictionary());
    }

    @NotNull
    public AggregatedDictionary getDictionary() {
        return this.dictionary;
    }

    public String toString() {
        return "AggregatedDictionaryState{dictionary=" + this.dictionary + '}';
    }
}

