/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.quickfixes.AcceptWordAsCorrect;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.RenameTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.CommentTokenizer;
import com.intellij.spellchecker.tokenizer.CustomFileTypeTokenizer;
import com.intellij.spellchecker.tokenizer.PsiIdentifierOwnerTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import org.jetbrains.annotations.NotNull;

public class SpellcheckingStrategy {
    protected final Tokenizer<PsiComment> myCommentTokenizer = new CommentTokenizer();
    protected final Tokenizer<XmlAttributeValue> myXmlAttributeTokenizer = new XmlAttributeValueTokenizer();
    public static final ExtensionPointName<SpellcheckingStrategy> EP_NAME = ExtensionPointName.create((String)"com.intellij.spellchecker.support");
    public static final Tokenizer EMPTY_TOKENIZER = new Tokenizer(){

        public void tokenize(@NotNull PsiElement element, TokenConsumer consumer2) {
        }
    };
    public static final Tokenizer<PsiElement> TEXT_TOKENIZER = new TokenizerBase<PsiElement>(PlainTextSplitter.getInstance());
    private static final SpellCheckerQuickFix[] BATCH_FIXES = new SpellCheckerQuickFix[]{new AcceptWordAsCorrect()};

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement injection;
        if (element instanceof PsiWhiteSpace) {
            return EMPTY_TOKENIZER;
        }
        if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element)) {
            return EMPTY_TOKENIZER;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return new PsiIdentifierOwnerTokenizer();
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment(element)) {
                return EMPTY_TOKENIZER;
            }
            return this.myCommentTokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            return this.myXmlAttributeTokenizer;
        }
        if (element instanceof PsiPlainText) {
            FileType fileType;
            PsiFile file2 = element.getContainingFile();
            FileType fileType2 = fileType = file2 == null ? null : file2.getFileType();
            if (fileType instanceof CustomSyntaxTableFileType) {
                return new CustomFileTypeTokenizer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            }
            return TEXT_TOKENIZER;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (injection = InjectedLanguageManager.getInstance((Project)element.getProject()).findInjectedElementAt(element.getContainingFile(), element.getTextOffset())) == null) {
            return TEXT_TOKENIZER;
        }
        return EMPTY_TOKENIZER;
    }

    public SpellCheckerQuickFix[] getRegularFixes(PsiElement element, int offset, @NotNull TextRange textRange, boolean useRename, String wordWithTypo) {
        return SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo);
    }

    public static SpellCheckerQuickFix[] getDefaultRegularFixes(boolean useRename, String wordWithTypo) {
        return new SpellCheckerQuickFix[]{useRename ? new RenameTo(wordWithTypo) : new ChangeTo(wordWithTypo), new AcceptWordAsCorrect(wordWithTypo)};
    }

    public static SpellCheckerQuickFix[] getDefaultBatchFixes() {
        return BATCH_FIXES;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        return true;
    }

    protected static class XmlAttributeValueTokenizer
    extends Tokenizer<XmlAttributeValue> {
        protected XmlAttributeValueTokenizer() {
        }

        @Override
        public void tokenize(@NotNull XmlAttributeValue element, TokenConsumer consumer2) {
            if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element)) {
                return;
            }
            String valueTextTrimmed = element.getValue().trim();
            if (valueTextTrimmed.startsWith("#") && valueTextTrimmed.length() <= 7 && XmlAttributeValueTokenizer.isHexString(valueTextTrimmed.substring(1))) {
                return;
            }
            consumer2.consumeToken((PsiElement)element, TextSplitter.getInstance());
        }

        private static boolean isHexString(String s) {
            for (int i2 = 0; i2 < s.length(); ++i2) {
                if (StringUtil.isHexDigit((char)s.charAt(i2))) continue;
                return false;
            }
            return true;
        }
    }
}

