/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProvidersElementList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIPackageOrClassReferenceElement
extends ASTWrapperPsiElement
implements PsiReference {
    public SPIPackageOrClassReferenceElement(@NotNull ASTNode node) {
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)this);
        return new TextRange(last.getStartOffsetInParent(), this.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        SPIClassProvidersElementList firstChild = (SPIClassProvidersElementList)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("spi_dummy", (FileType)SPIFileType.INSTANCE, (CharSequence)newElementName).getFirstChild();
        PsiTreeUtil.getDeepestLast((PsiElement)this).replace(PsiTreeUtil.getDeepestLast((PsiElement)((PsiElement)firstChild.getElements().get(0))));
        return this;
    }

    @Nullable
    public PsiElement resolve() {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(this.getText());
        if (aPackage != null) {
            return aPackage;
        }
        return ClassUtil.findPsiClass((PsiManager)this.getManager(), (String)this.getText(), null, (boolean)true, (GlobalSearchScope)this.getResolveScope());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String newElementName;
        if (element instanceof PsiPackage) {
            newElementName = ((PsiPackage)element).getQualifiedName();
        } else if (element instanceof PsiClass) {
            newElementName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element));
        } else {
            return null;
        }
        if (newElementName != null) {
            SPIClassProvidersElementList firstChild = (SPIClassProvidersElementList)PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("spi_dummy", (FileType)SPIFileType.INSTANCE, (CharSequence)newElementName).getFirstChild();
            return this.replace((PsiElement)firstChild.getElements().get(0));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiPackage) {
            return this.getText().equals(((PsiPackage)element).getQualifiedName());
        }
        if (element instanceof PsiClass) {
            return this.getText().equals(ClassUtil.getJVMClassName((PsiClass)((PsiClass)element)));
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

