/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchUtil {
    private static LanguageFileType ourDefaultFileType = null;
    public static boolean ourUseUniversalMatchingAlgorithm = false;
    private static StructuralSearchProfile[] ourNewStyleProfiles;
    private static List<Configuration> ourPredefinedConfigurations;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile2 != null && profile2.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @NotNull
    public static PsiElement getPresentableElement(@NotNull PsiElement element) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile2 == null) {
            return element;
        }
        return profile2.getPresentableElement(StructuralSearchUtil.getParentIfIdentifier(element));
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        if (ourNewStyleProfiles == null) {
            ArrayList<StructuralSearchProfile> list = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile profile2 : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(profile2 instanceof StructuralSearchProfileBase)) continue;
                list.add(profile2);
            }
            list.add(new XmlStructuralSearchProfile());
            ourNewStyleProfiles = list.toArray(new StructuralSearchProfile[list.size()]);
        }
        return ourNewStyleProfiles;
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    public static FileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile2.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        assert (ourDefaultFileType instanceof LanguageFileType) : "file type not valid for structural search: " + ourDefaultFileType.getName();
        return ourDefaultFileType;
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
            if (!profile2.isMyLanguage(language)) continue;
            return profile2;
        }
        return null;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(FileType fileType) {
        for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
            if (!profile2.canProcess(fileType)) continue;
            return profile2;
        }
        return null;
    }

    @NotNull
    public static FileType[] getSuitableFileTypes() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        ArrayList<LanguageFileType> result2 = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : allFileTypes) {
            if (!(fileType instanceof LanguageFileType)) continue;
            result2.add(fileType);
        }
        return result2.toArray(new FileType[result2.size()]);
    }

    public static String shieldSpecialChars(String word) {
        StringBuilder buf = new StringBuilder(word.length());
        for (int i2 = 0; i2 < word.length(); ++i2) {
            if ("*(){}[]^$\\.-|".indexOf(word.charAt(i2)) != -1) {
                buf.append("\\");
            }
            buf.append(word.charAt(i2));
        }
        return buf.toString();
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result2 = new ArrayList();
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result2, profile2.getPredefinedTemplates());
            }
            Collections.sort(result2);
            ourPredefinedConfigurations = Collections.unmodifiableList(result2);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile2 != null && profile2.isDocCommentOwner(match);
    }

    static {
        ourPredefinedConfigurations = null;
    }
}

