/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.filters.XmlLexicalNodesFilter;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    private XmlLexicalNodesFilter myLexicalNodesFilter;

    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        elements[0].getParent().accept((PsiElementVisitor)new XmlCompilingVisitor(globalVisitor));
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        return new XmlMatchingVisitor(globalVisitor);
    }

    @Override
    @NotNull
    public PsiElementVisitor getLexicalNodesFilter(@NotNull LexicalNodesFilter filter) {
        if (this.myLexicalNodesFilter == null) {
            this.myLexicalNodesFilter = new XmlLexicalNodesFilter(filter);
        }
        return this.myLexicalNodesFilter;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new XmlCompiledPattern();
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String text1 = context == PatternTreeContext.File ? text : "<QQQ>" + text + "</QQQ>";
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project2).createFileFromText("dummy." + ext, fileType, (CharSequence)text1, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document = HtmlUtil.getRealXmlDocument(((XmlFile)fileFromText).getDocument());
        if (context == PatternTreeContext.File) {
            return new PsiElement[]{document};
        }
        return document.getRootTag().getValue().getChildren();
    }

    @Override
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public FileType detectFileType(@NotNull PsiElement context) {
        Language contextLanguage;
        PsiFile file2 = context instanceof PsiFile ? (PsiFile)context : context.getContainingFile();
        Language language = contextLanguage = context instanceof PsiFile ? null : context.getLanguage();
        if (file2.getLanguage() == StdLanguages.HTML || file2.getFileType() == StdFileTypes.JSP && contextLanguage == StdLanguages.HTML) {
            return StdFileTypes.HTML;
        }
        return StdFileTypes.XML;
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        return new MyReplaceHandler(context);
    }

    private static void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent, ReplacementContext context) {
        PsiElement[] statements = ReplacerUtil.createTreeForReplacement(replacementToMake, PatternTreeContext.Block, context);
        if (statements.length > 1) {
            elementParent.addRangeBefore(statements[0], statements[statements.length - 1], elementToReplace);
        } else if (statements.length == 1) {
            PsiElement replacement = statements[0];
            Replacer.handleComments(elementToReplace, replacement, context);
            try {
                elementParent.addBefore(replacement, elementToReplace);
            }
            catch (IncorrectOperationException e) {
                elementToReplace.replace(replacement);
            }
        }
        int matchSize = info.getMatchesCount();
        for (int i2 = 0; i2 < matchSize; ++i2) {
            PsiElement next;
            PsiElement element = info.getMatch(i2);
            if (element == null) continue;
            PsiElement firstToDelete = element;
            PsiElement lastToDelete = element;
            PsiElement prevSibling = element.getPrevSibling();
            PsiElement nextSibling = element.getNextSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                firstToDelete = prevSibling;
            } else if (prevSibling == null && nextSibling instanceof PsiWhiteSpace) {
                lastToDelete = nextSibling;
            }
            if (nextSibling instanceof XmlText && i2 + 1 < matchSize && (next = info.getMatch(i2 + 1)) != null && next == nextSibling.getNextSibling()) {
                lastToDelete = nextSibling;
            }
            element.getParent().deleteChildRange(firstToDelete, lastToDelete);
        }
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return XmlPredefinedConfigurations.createPredefinedTemplates();
    }

    private static class XmlPredefinedConfigurations {
        private static final String HTML_XML = SSRBundle.message("xml_html.category", new Object[0]);

        private XmlPredefinedConfigurations() {
        }

        private static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo("xml tag", "<'a/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute", "<'_tag 'attribute=\"'_value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute", "<'_tag 'attribute />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute value", "<'_tag '_attribute=\"'value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute value", "<'_tag '_attribute='value />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml/html tag value", "<table>'_content*</table>", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<li> not contained in <ul> or <ol>", "[!within( \"<'_tag:[regex( ul|ol )] />\" )]<li />", HTML_XML, (FileType)StdFileTypes.HTML)};
        }
    }

    private static class MyReplaceHandler
    extends StructuralReplaceHandler {
        private final ReplacementContext myContext;

        private MyReplaceHandler(ReplacementContext context) {
            this.myContext = context;
        }

        @Override
        public void replace(ReplacementInfo info, ReplaceOptions options) {
            PsiElement[] statements;
            PsiElement elementToReplace = info.getMatch(0);
            assert (elementToReplace != null);
            PsiElement elementParent = elementToReplace.getParent();
            String replacementToMake = info.getReplacement();
            boolean listContext = elementToReplace.getParent() instanceof XmlTag;
            if (listContext) {
                XmlStructuralSearchProfile.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent, this.myContext);
            }
            if ((statements = ReplacerUtil.createTreeForReplacement(replacementToMake, PatternTreeContext.Block, this.myContext)).length > 0) {
                PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, statements, replacementToMake, elementParent);
                Replacer.handleComments(elementToReplace, replacement, this.myContext);
                elementToReplace.replace(replacement);
            } else {
                elementToReplace.delete();
            }
        }
    }
}

