/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class DocDataHandler
extends MatchingHandler {
    @NonNls
    private static final String P_STR = "^\\s*((?:\\w|_|\\-|\\$)+)\\s*(?:=\\s*\"(.*)\"\\s*)?$";
    private static final Pattern p = Pattern.compile("^\\s*((?:\\w|_|\\-|\\$)+)\\s*(?:=\\s*\"(.*)\"\\s*)?$", 2);

    @Override
    public boolean match(PsiElement node, PsiElement match, MatchContext context) {
        String text1 = node.getText();
        text1 = DocDataHandler.getTextFromNode(node, text1);
        Matcher m1 = p.matcher(text1);
        String text2 = match.getText();
        text2 = DocDataHandler.getTextFromNode(match, text2);
        Matcher m2 = p.matcher(text2);
        if (m1.matches() && m2.matches()) {
            String name = m1.group(1);
            String name2 = m2.group(1);
            boolean isTypedName = context.getPattern().isTypedVar(name);
            if (name.equals(name2) || isTypedName) {
                String value2 = m1.group(2);
                String value22 = m2.group(2);
                if (!(value2 == null || value22 != null && value22.matches(value2))) {
                    return false;
                }
                if (isTypedName) {
                    SubstitutionHandler handler2 = (SubstitutionHandler)context.getPattern().getHandler(name);
                    return handler2.handle(match, context);
                }
                return true;
            }
        }
        return text1.equals(text2);
    }

    private static String getTextFromNode(PsiElement node, String text1) {
        PsiElement nextSibling = node.getNextSibling();
        if (nextSibling instanceof PsiDocTagValue) {
            text1 = text1 + nextSibling.getText();
            if ((nextSibling = nextSibling.getNextSibling()) instanceof PsiDocToken && ((PsiDocToken)nextSibling).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA) {
                text1 = text1 + nextSibling.getText();
            }
        }
        return text1;
    }
}

