/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralWithSubstitutionHandler
extends MatchingHandler {
    private final String matchExpression;
    private Matcher matcher;
    private final List<SubstitutionHandler> handlers;

    public LiteralWithSubstitutionHandler(String _matchedExpression, List<SubstitutionHandler> _handlers) {
        this.matchExpression = _matchedExpression;
        this.handlers = _handlers;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        String text = matchedNode.getText();
        if (this.matcher == null) {
            this.matcher = Pattern.compile(this.matchExpression).matcher(text);
        } else {
            this.matcher.reset(text);
        }
        if (!this.matcher.find()) {
            return false;
        }
        for (int i2 = 0; i2 < this.handlers.size(); ++i2) {
            SubstitutionHandler handler2 = this.handlers.get(i2);
            if (handler2.handle(matchedNode, this.matcher.start(i2 + 1), this.matcher.end(i2 + 1), context)) continue;
            return false;
        }
        return true;
    }
}

