/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspectionCompiledPatternsCache {
    private static final Key<Map<Configuration, MatchContext>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");

    @NotNull
    static Map<Configuration, MatchContext> getCompiledOptions(@NotNull List<Configuration> configurations, @NotNull Project project2) {
        Map cache2 = (Map)ObjectUtils.notNull((Object)project2.getUserData(COMPILED_OPTIONS_KEY), new HashMap());
        if (!SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache2)) {
            Matcher matcher = new Matcher(project2);
            matcher.precompileOptions(configurations, cache2);
            project2.putUserData(COMPILED_OPTIONS_KEY, (Object)cache2);
        }
        return configurations.stream().collect(Collectors.toMap(Function.identity(), cache2::get, (c1, c2) -> c2));
    }

    private static boolean areConfigurationsInCache(@NotNull List<Configuration> configurations, @NotNull Map<Configuration, MatchContext> cache2) {
        for (Configuration configuration : configurations) {
            if (cache2.containsKey(configuration)) continue;
            return false;
        }
        return true;
    }

    public static void removeFromCache(Configuration configuration, @NotNull Project project2) {
        Map cache2 = (Map)project2.getUserData(COMPILED_OPTIONS_KEY);
        if (cache2 != null) {
            cache2.remove(configuration);
        }
    }
}

