/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdom.Element;

public class SSBasedInspectionOptions {
    private final JBList myTemplatesList;
    private final List<Configuration> myConfigurations;

    public SSBasedInspectionOptions(List<Configuration> configurations) {
        this.myConfigurations = configurations;
        this.myTemplatesList = new JBList((ListModel)new MyListModel());
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
                Configuration configuration = (Configuration)SSBasedInspectionOptions.this.myConfigurations.get(index);
                component.setText(configuration.getName());
                return component;
            }
        });
    }

    private static void copyConfiguration(Configuration configuration, Configuration newConfiguration) {
        Element temp = new Element("temp");
        configuration.writeExternal(temp);
        newConfiguration.readExternal(temp);
    }

    private void addTemplate(SearchDialogFactory searchDialogFactory) {
        SearchDialog dialog2 = SSBasedInspectionOptions.createDialog(searchDialogFactory);
        if (!dialog2.showAndGet()) {
            return;
        }
        Configuration configuration = dialog2.getConfiguration();
        if (configuration.getName() == null || configuration.getName().equals(SearchDialog.USER_DEFINED)) {
            String name = dialog2.showSaveTemplateAsDialog();
            if (name != null) {
                name = ConfigurationManager.findAppropriateName(this.myConfigurations, name, dialog2.getProject());
            }
            if (name == null) {
                return;
            }
            configuration.setName(name);
        }
        this.myConfigurations.add(configuration);
        this.configurationsChanged(dialog2.getSearchContext());
    }

    private static SearchDialog createDialog(SearchDialogFactory searchDialogFactory) {
        SearchContext searchContext = SSBasedInspectionOptions.createSearchContext();
        return searchDialogFactory.createDialog(searchContext);
    }

    private static SearchContext createSearchContext() {
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", new DefaultActionGroup().getTemplatePresentation(), ActionManager.getInstance(), 0);
        return SearchContext.buildFromDataContext(event.getDataContext());
    }

    public void configurationsChanged(SearchContext searchContext) {
        ((MyListModel)this.myTemplatesList.getModel()).fireContentsChanged();
        DaemonCodeAnalyzer.getInstance((Project)searchContext.getProject()).restart();
    }

    public JPanel getComponent() {
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(new JLabel(SSRBundle.message("SSRInspection.selected.templates", new Object[0])));
        panel2.add(ToolbarDecorator.createDecorator((JList)this.myTemplatesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AnAction[] children2 = new AnAction[]{new AnAction(SSRBundle.message("SSRInspection.add.search.template.button", new Object[0])){

                    public void actionPerformed(AnActionEvent e) {
                        SSBasedInspectionOptions.this.addTemplate(new SearchDialogFactory(){

                            @Override
                            public SearchDialog createDialog(SearchContext searchContext) {
                                return new SearchDialog(searchContext, false, false);
                            }
                        });
                    }
                }, new AnAction(SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0])){

                    public void actionPerformed(AnActionEvent e) {
                        SSBasedInspectionOptions.this.addTemplate(new SearchDialogFactory(){

                            @Override
                            public SearchDialog createDialog(SearchContext searchContext) {
                                return new ReplaceDialog(searchContext, false, false);
                            }
                        });
                    }
                }};
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children2), DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performEditAction();
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Project project2 = e.getProject();
                return project2 != null && !DumbService.isDumb((Project)project2);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] selected;
                SearchContext context = SSBasedInspectionOptions.createSearchContext();
                for (Object o : selected = SSBasedInspectionOptions.this.myTemplatesList.getSelectedValues()) {
                    Configuration configuration = (Configuration)o;
                    SSBasedInspectionOptions.this.myConfigurations.remove(configuration);
                    SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration, context.getProject());
                }
                SSBasedInspectionOptions.this.configurationsChanged(context);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Project project2 = e.getProject();
                return project2 != null && !DumbService.isDumb((Project)project2);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(false);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SSBasedInspectionOptions.this.performMoveUpDown(true);
            }
        }).setPreferredSize(new Dimension(-1, 100)).createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)panel2));
                if (project2 != null && !DumbService.isDumb((Project)project2)) {
                    SSBasedInspectionOptions.this.performEditAction();
                }
                return true;
            }
        }.installOn((Component)this.myTemplatesList);
        return panel2;
    }

    private void performMoveUpDown(boolean down) {
        int i2;
        int[] indices2 = this.myTemplatesList.getSelectedIndices();
        if (indices2.length == 0) {
            return;
        }
        int delta = down ? 1 : -1;
        this.myTemplatesList.removeSelectionInterval(0, this.myConfigurations.size() - 1);
        int n = i2 = down ? indices2[indices2.length - 1] : 0;
        while (down ? i2 >= 0 : i2 < indices2.length) {
            int index = indices2[i2];
            Configuration temp = this.myConfigurations.get(index);
            this.myConfigurations.set(index, this.myConfigurations.get(index + delta));
            this.myConfigurations.set(index + delta, temp);
            this.myTemplatesList.addSelectionInterval(index + delta, index + delta);
            i2 -= delta;
        }
        int index = down ? this.myTemplatesList.getMaxSelectionIndex() : this.myTemplatesList.getMinSelectionIndex();
        Rectangle cellBounds = this.myTemplatesList.getCellBounds(index, index);
        if (cellBounds != null) {
            this.myTemplatesList.scrollRectToVisible(cellBounds);
        }
    }

    private void performEditAction() {
        final Configuration configuration = (Configuration)this.myTemplatesList.getSelectedValue();
        if (configuration == null) {
            return;
        }
        SearchDialog dialog2 = SSBasedInspectionOptions.createDialog(new SearchDialogFactory(){

            @Override
            public SearchDialog createDialog(SearchContext searchContext) {
                if (configuration instanceof SearchConfiguration) {
                    return new SearchDialog(searchContext, false, false){

                        @Override
                        public Configuration createConfiguration() {
                            SearchConfiguration newConfiguration = new SearchConfiguration();
                            SSBasedInspectionOptions.copyConfiguration(configuration, newConfiguration);
                            return newConfiguration;
                        }
                    };
                }
                return new ReplaceDialog(searchContext, false, false){

                    @Override
                    public Configuration createConfiguration() {
                        ReplaceConfiguration newConfiguration = new ReplaceConfiguration();
                        SSBasedInspectionOptions.copyConfiguration(configuration, newConfiguration);
                        return newConfiguration;
                    }
                };
            }
        });
        dialog2.setValuesFromConfig(configuration);
        dialog2.setUseLastConfiguration(true);
        if (!dialog2.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog2.getConfiguration();
        int index = this.myConfigurations.indexOf(configuration);
        this.myConfigurations.remove(index);
        this.myConfigurations.add(index, newConfiguration);
        SearchContext context = dialog2.getSearchContext();
        SSBasedInspectionCompiledPatternsCache.removeFromCache(configuration, context.getProject());
        this.configurationsChanged(context);
    }

    private class MyListModel
    extends AbstractListModel {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return SSBasedInspectionOptions.this.myConfigurations.size();
        }

        @Override
        public Object getElementAt(int index) {
            return index < SSBasedInspectionOptions.this.myConfigurations.size() ? SSBasedInspectionOptions.this.myConfigurations.get(index) : null;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(SSBasedInspectionOptions.this.myTemplatesList, -1, -1);
        }
    }

    static interface SearchDialogFactory {
        public SearchDialog createDialog(SearchContext var1);
    }
}

