/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExistingTemplatesComponent {
    private final Tree patternTree;
    private final DefaultTreeModel patternTreeModel;
    private final DefaultMutableTreeNode userTemplatesNode;
    private final JComponent panel;
    private final CollectionListModel<Configuration> historyModel;
    private final JList historyList;
    private final JComponent historyPanel;
    private DialogWrapper owner;
    private final Project project;

    private ExistingTemplatesComponent(Project project2) {
        this.project = project2;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.patternTreeModel = new DefaultTreeModel(root);
        this.patternTree = ExistingTemplatesComponent.createTree(this.patternTreeModel);
        DefaultMutableTreeNode parent = null;
        String lastCategory = null;
        ArrayList<DefaultMutableTreeNode> nodesToExpand = new ArrayList<DefaultMutableTreeNode>();
        List<Configuration> predefined = StructuralSearchUtil.getPredefinedTemplates();
        for (Configuration configuration : predefined) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(configuration);
            if (lastCategory == null || !lastCategory.equals(configuration.getCategory())) {
                if (configuration.getCategory().length() > 0) {
                    parent = new DefaultMutableTreeNode(configuration.getCategory());
                    root.add(parent);
                    nodesToExpand.add(parent);
                    lastCategory = configuration.getCategory();
                } else {
                    root.add(node);
                    continue;
                }
            }
            parent.add(node);
        }
        final ConfigurationManager configurationManager = ConfigurationManager.getInstance(project2);
        this.userTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        root.add(this.userTemplatesNode);
        this.setUserTemplates(configurationManager);
        for (DefaultMutableTreeNode nodeToExpand : nodesToExpand) {
            this.patternTree.expandPath(new TreePath(new Object[]{root, nodeToExpand}));
        }
        DefaultTreeExpander defaultTreeExpander = new DefaultTreeExpander((JTree)this.patternTree);
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        this.panel = ToolbarDecorator.createDecorator((JTree)this.patternTree).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object selection = ExistingTemplatesComponent.this.patternTree.getLastSelectedPathComponent();
                if (!(selection instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
                if (!(node.getUserObject() instanceof Configuration)) {
                    return;
                }
                Configuration configuration = (Configuration)node.getUserObject();
                if (configuration.isPredefined()) {
                    return;
                }
                int[] rows = ExistingTemplatesComponent.this.patternTree.getSelectionRows();
                if (rows != null && rows.length > 0) {
                    ExistingTemplatesComponent.this.patternTree.addSelectionRow(rows[0] - 1);
                }
                ExistingTemplatesComponent.this.patternTreeModel.removeNodeFromParent(node);
                configurationManager.removeConfiguration(configuration);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                DefaultMutableTreeNode node;
                Object userObject;
                Object selection = ExistingTemplatesComponent.this.patternTree.getLastSelectedPathComponent();
                if (selection instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)selection).getUserObject()) instanceof Configuration) {
                    Configuration configuration = (Configuration)userObject;
                    return !configuration.isPredefined();
                }
                return false;
            }
        }).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createExpandAllAction((TreeExpander)defaultTreeExpander, (JComponent)this.patternTree))).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createCollapseAllAction((TreeExpander)defaultTreeExpander, (JComponent)this.patternTree))).createPanel();
        new JPanel(new BorderLayout());
        this.configureSelectTemplateAction((JComponent)this.patternTree);
        this.historyModel = new CollectionListModel(configurationManager.getHistoryConfigurations());
        this.historyPanel = new JPanel(new BorderLayout());
        this.historyPanel.add("North", new JLabel(SSRBundle.message("used.templates", new Object[0])));
        this.historyList = new JBList(this.historyModel);
        this.historyPanel.add("Center", ScrollPaneFactory.createScrollPane((Component)this.historyList));
        this.historyList.setSelectionMode(0);
        this.historyList.setSelectedIndex(0);
        ListSpeedSearch speedSearch = new ListSpeedSearch(this.historyList, new Convertor<Object, String>(){

            public String convert(Object o) {
                return o instanceof Configuration ? ((Configuration)o).getName() : o.toString();
            }
        });
        this.historyList.setCellRenderer(new ExistingTemplatesListCellRenderer(speedSearch));
        this.configureSelectTemplateAction(this.historyList);
    }

    public void setUserTemplates(ConfigurationManager configurationManager) {
        this.userTemplatesNode.removeAllChildren();
        if (configurationManager.getConfigurations() != null) {
            for (Configuration config : configurationManager.getConfigurations()) {
                this.userTemplatesNode.add(new DefaultMutableTreeNode(config));
            }
        }
        this.patternTreeModel.reload(this.userTemplatesNode);
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.userTemplatesNode}));
    }

    private void configureSelectTemplateAction(JComponent component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ExistingTemplatesComponent.this.owner.close(0);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ExistingTemplatesComponent.this.owner.close(0);
                return true;
            }
        }.installOn((Component)component);
    }

    private static Tree createTree(TreeModel treeModel) {
        Tree tree = new Tree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setDragEnabled(false);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(1);
        TreeSpeedSearch speedSearch = new TreeSpeedSearch(tree, new Convertor<TreePath, String>(){

            public String convert(TreePath object) {
                Object userObject = ((DefaultMutableTreeNode)object.getLastPathComponent()).getUserObject();
                return userObject instanceof Configuration ? ((Configuration)userObject).getName() : userObject.toString();
            }
        });
        tree.setCellRenderer((TreeCellRenderer)((Object)new ExistingTemplatesTreeCellRenderer(speedSearch)));
        return tree;
    }

    public JTree getPatternTree() {
        return this.patternTree;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public static ExistingTemplatesComponent getInstance(Project project2) {
        return (ExistingTemplatesComponent)ServiceManager.getService((Project)project2, ExistingTemplatesComponent.class);
    }

    void addConfigurationToHistory(Configuration configuration) {
        this.historyModel.remove((Object)configuration);
        this.historyModel.add(0, (Object)configuration);
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(this.project);
        configurationManager.addHistoryConfigurationToFront(configuration);
        this.historyList.setSelectedIndex(0);
        if (this.historyModel.getSize() > 25) {
            configurationManager.removeHistoryConfiguration((Configuration)this.historyModel.getElementAt(25));
            this.historyModel.remove(25);
        }
    }

    public JList getHistoryList() {
        return this.historyList;
    }

    public JComponent getHistoryPanel() {
        return this.historyPanel;
    }

    public void setOwner(DialogWrapper owner) {
        this.owner = owner;
    }

    private static class ExistingTemplatesTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        ExistingTemplatesTreeCellRenderer(TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int style;
            String text;
            Color foreground;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value2;
            Object userObject = treeNode.getUserObject();
            if (userObject == null) {
                return;
            }
            Color background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : UIUtil.getTreeTextBackground();
            Color color = foreground = selected && hasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground();
            if (userObject instanceof Configuration) {
                text = ((Configuration)userObject).getName();
                style = 0;
            } else {
                text = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments(this.mySpeedSearch.getEnteredPrefix(), text, style, foreground, background, (SimpleColoredComponent)this);
        }
    }

    private static class ExistingTemplatesListCellRenderer
    extends ColoredListCellRenderer {
        private final ListSpeedSearch mySpeedSearch;

        public ExistingTemplatesListCellRenderer(ListSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean focus) {
            if (!(value2 instanceof Configuration)) {
                return;
            }
            Configuration configuration = (Configuration)value2;
            Color background = selected && !focus ? UIUtil.getListUnfocusedSelectionBackground() : UIUtil.getListBackground((boolean)selected);
            Color foreground = UIUtil.getListForeground((boolean)selected);
            this.setPaintFocusBorder(false);
            SearchUtil.appendFragments(this.mySpeedSearch.getEnteredPrefix(), configuration.getName(), 0, foreground, background, (SimpleColoredComponent)this);
            long created = configuration.getCreated();
            if (created > 0L) {
                String createdString = DateFormatUtil.formatPrettyDateTime((long)created);
                this.append(" (" + createdString + ')', selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }
}

