/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.ArtifactBuildTask;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger LOG = Logger.getInstance(InternalProjectTaskRunner.class);

    public void run(@NotNull Project project2, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        CompileStatusNotification compileNotification = callback == null ? null : (aborted, errors, warnings, compileContext) -> callback.finished(new ProjectTaskResult(aborted, errors, warnings));
        Map<Class<? extends ProjectTask>, List<ProjectTask>> taskMap = InternalProjectTaskRunner.groupBy(tasks);
        InternalProjectTaskRunner.runModulesBuildTasks(project2, context, compileNotification, taskMap);
        InternalProjectTaskRunner.runFilesBuildTasks(project2, compileNotification, taskMap);
        InternalProjectTaskRunner.runArtifactsBuildTasks(project2, context, compileNotification, taskMap);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        return true;
    }

    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        return null;
    }

    public static Map<Class<? extends ProjectTask>, List<ProjectTask>> groupBy(@NotNull Collection<? extends ProjectTask> tasks) {
        return tasks.stream().collect(Collectors.groupingBy(o -> {
            if (o instanceof ModuleFilesBuildTask) {
                return ModuleFilesBuildTask.class;
            }
            if (o instanceof ModuleBuildTask) {
                return ModuleBuildTask.class;
            }
            if (o instanceof ArtifactBuildTask) {
                return ArtifactBuildTask.class;
            }
            return o.getClass();
        }));
    }

    private static void runModulesBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @Nullable CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(ModuleBuildTask.class);
        if (ContainerUtil.isEmpty((Collection)buildTasks)) {
            return;
        }
        ModulesBuildSettings modulesBuildSettings = InternalProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        CompileScope scope = InternalProjectTaskRunner.createScope(compilerManager, context, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
        if (modulesBuildSettings.isIncrementalBuild) {
            compilerManager.make(scope, compileNotification);
        } else {
            compilerManager.compile(scope, compileNotification);
        }
    }

    private static ModulesBuildSettings assembleModulesBuildSettings(Collection<? extends ProjectTask> buildTasks) {
        boolean includeRuntimeDependencies;
        SmartList modules = new SmartList();
        List incrementalTasks = ContainerUtil.newSmartList();
        List excludeDependentTasks = ContainerUtil.newSmartList();
        List excludeRuntimeTasks = ContainerUtil.newSmartList();
        for (ProjectTask projectTask : buildTasks) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            modules.add(moduleBuildTask.getModule());
            if (moduleBuildTask.isIncrementalBuild()) {
                incrementalTasks.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeDependentModules()) {
                excludeDependentTasks.add(moduleBuildTask);
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) continue;
            excludeRuntimeTasks.add(moduleBuildTask);
        }
        boolean isIncrementalBuild = incrementalTasks.size() == buildTasks.size();
        boolean bl = excludeDependentTasks.size() != buildTasks.size();
        boolean bl2 = includeRuntimeDependencies = excludeRuntimeTasks.size() != buildTasks.size();
        if (!isIncrementalBuild && !incrementalTasks.isEmpty()) {
            InternalProjectTaskRunner.assertModuleBuildSettingsConsistent(incrementalTasks, "will be built ignoring incremental build setting");
        }
        if (bl && !excludeDependentTasks.isEmpty()) {
            InternalProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeDependentTasks, "will be built along with dependent modules");
        }
        if (includeRuntimeDependencies && !excludeRuntimeTasks.isEmpty()) {
            InternalProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeRuntimeTasks, "will be built along with runtime dependencies");
        }
        return new ModulesBuildSettings(isIncrementalBuild, bl, includeRuntimeDependencies, (Collection<Module>)modules);
    }

    private static void assertModuleBuildSettingsConsistent(Collection<ModuleBuildTask> moduleBuildTasks, String warnMsg) {
        String moduleNames = StringUtil.join(moduleBuildTasks, task -> task.getModule().getName(), (String)", ");
        LOG.warn("Module" + (moduleBuildTasks.size() > 1 ? "s" : "") + " : '" + moduleNames + "' " + warnMsg);
    }

    private static CompileScope createScope(CompilerManager compilerManager, ProjectTaskContext context, Collection<Module> modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        CompileScope scope = compilerManager.createModulesCompileScope(modules.toArray(new Module[modules.size()]), includeDependentModules, includeRuntimeDependencies);
        RunConfiguration configuration = context.getRunConfiguration();
        if (configuration != null) {
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_KEY, (Object)configuration);
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY, (Object)configuration.getType().getId());
        }
        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, context.getSessionId());
        return scope;
    }

    private static void runFilesBuildTasks(@NotNull Project project2, @Nullable CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection filesTargets = tasksMap.get(ModuleFilesBuildTask.class);
        if (!ContainerUtil.isEmpty((Collection)filesTargets)) {
            VirtualFile[] files = (VirtualFile[])filesTargets.stream().flatMap(target -> Stream.of(((ModuleFilesBuildTask)ModuleFilesBuildTask.class.cast(target)).getFiles())).toArray(VirtualFile[]::new);
            CompilerManager.getInstance((Project)project2).compile(files, compileNotification);
        }
    }

    private static void runArtifactsBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @Nullable CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(ArtifactBuildTask.class);
        if (!ContainerUtil.isEmpty((Collection)buildTasks)) {
            SmartList toMake = new SmartList();
            SmartList toCompile = new SmartList();
            for (ProjectTask buildProjectTask : buildTasks) {
                ArtifactBuildTask artifactBuildTask = (ArtifactBuildTask)buildProjectTask;
                if (artifactBuildTask.isIncrementalBuild()) {
                    toMake.add(artifactBuildTask.getArtifact());
                    continue;
                }
                toCompile.add(artifactBuildTask.getArtifact());
            }
            InternalProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toMake, context.getSessionId(), compileNotification, false);
            InternalProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toCompile, context.getSessionId(), compileNotification, true);
        }
    }

    private static void buildArtifacts(@NotNull Project project2, @NotNull List<Artifact> artifacts, @Nullable Object sessionId, @Nullable CompileStatusNotification compileNotification, boolean forceArtifactBuild) {
        if (!artifacts.isEmpty()) {
            CompileScope scope = ArtifactCompileScope.createArtifactsScope(project2, artifacts, forceArtifactBuild);
            ArtifactsWorkspaceSettings.getInstance(project2).setArtifactsToBuild(artifacts);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, sessionId);
            CompilerManager.getInstance((Project)project2).make(scope, compileNotification);
        }
    }

    private static class ModulesBuildSettings {
        final boolean isIncrementalBuild;
        final boolean includeDependentModules;
        final boolean includeRuntimeDependencies;
        final Collection<Module> modules;

        public ModulesBuildSettings(boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies, Collection<Module> modules) {
            this.isIncrementalBuild = isIncrementalBuild;
            this.includeDependentModules = includeDependentModules;
            this.includeRuntimeDependencies = includeRuntimeDependencies;
            this.modules = modules;
        }
    }
}

