/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ArtifactBuildTaskImpl;
import com.intellij.task.impl.InternalProjectTaskRunner;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private final ProjectTaskRunner myDefaultProjectTaskRunner = new InternalProjectTaskRunner();

    public ProjectTaskManagerImpl(@NotNull Project project2) {
        super(project2);
    }

    public void build(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback) {
        this.run(this.createModulesBuildTask(modules, true, true, false), callback);
    }

    public void rebuild(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback) {
        this.run(this.createModulesBuildTask(modules, false, false, false), callback);
    }

    public void compile(@NotNull VirtualFile[] files, @Nullable ProjectTaskNotification callback) {
        List buildTasks = Arrays.stream(files).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet().stream().map(entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue())).collect(Collectors.toList());
        this.run(new ProjectTaskList(buildTasks), callback);
    }

    public void build(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback) {
        this.doBuild(artifacts, callback, true);
    }

    public void rebuild(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback) {
        this.doBuild(artifacts, callback, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification callback) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), callback);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification callback) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), callback);
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project2) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project2).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module2}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules.length == 1 ? new ModuleBuildTaskImpl(modules[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])modules), module2 -> new ModuleBuildTaskImpl((Module)module2, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createArtifactsBuildTask(boolean isIncrementalBuild, Artifact ... artifacts) {
        return artifacts.length == 1 ? new ArtifactBuildTaskImpl(artifacts[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])artifacts), artifact -> new ArtifactBuildTaskImpl((Artifact)artifact, isIncrementalBuild)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback) {
        this.run(new ProjectTaskContext(), projectTask, callback);
    }

    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, final @Nullable ProjectTaskNotification callback) {
        SmartList toRun = new SmartList();
        Consumer taskClassifier = arg_0 -> this.lambda$run$5((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<Collection<? extends ProjectTask>>)taskClassifier);
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessNotify(callback);
            return;
        }
        final AtomicInteger inProgressCounter = new AtomicInteger(toRun.size());
        final AtomicInteger errorsCounter = new AtomicInteger();
        final AtomicInteger warningsCounter = new AtomicInteger();
        final AtomicBoolean abortedFlag = new AtomicBoolean(false);
        ProjectTaskNotification chunkStatusNotification = callback == null ? null : new ProjectTaskNotification(){

            public void finished(@NotNull ProjectTaskResult executionResult) {
                int inProgress = inProgressCounter.decrementAndGet();
                int allErrors = errorsCounter.addAndGet(executionResult.getErrors());
                int allWarnings = warningsCounter.addAndGet(executionResult.getWarnings());
                if (executionResult.isAborted()) {
                    abortedFlag.set(true);
                }
                if (inProgress == 0) {
                    callback.finished(new ProjectTaskResult(abortedFlag.get(), allErrors, allWarnings));
                }
            }
        };
        toRun.forEach(pair -> {
            if (((Collection)pair.second).isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessNotify(chunkStatusNotification);
            } else {
                ((ProjectTaskRunner)pair.first).run(this.myProject, context, chunkStatusNotification, (Collection)pair.second);
            }
        });
    }

    private static void sendSuccessNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<Collection<? extends ProjectTask>> consumer2) {
        for (ProjectTask projectTask : tasks) {
            Collection<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer2);
        }
        consumer2.consume(tasks);
    }

    @NotNull
    private static ProjectTaskRunner[] getTaskRunners() {
        return (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
    }

    private void doBuild(@NotNull Artifact[] artifacts, @Nullable ProjectTaskNotification callback, boolean isIncrementalBuild) {
        this.run(this.createArtifactsBuildTask(isIncrementalBuild, artifacts), callback);
    }

    private /* synthetic */ void lambda$run$5(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> {
            for (ProjectTaskRunner runner : ProjectTaskManagerImpl.getTaskRunners()) {
                if (!runner.canRun(aTask)) continue;
                return runner;
            }
            return this.myDefaultProjectTaskRunner;
        }));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }
}

