/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    private static final List<String> MOCKING_SUPPORT_CLASSES = Arrays.asList("org.easymock.internal.MocksBehavior", "org.mockito.internal.stubbing.OngoingStubbingImpl");
    private static final Condition<Object> SHOULD_EXAMINE_VALUE = o -> !MOCKING_SUPPORT_CLASSES.contains(o.getClass().getName());

    public static void checkProjectLeak() throws Exception {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault() && !project2.isLight());
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class suspectClass) throws AssertionError {
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.processLeaks(roots, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? PlatformTestCase.getCreationPlace((Project)leaked) : "";
            System.out.println("Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place);
            System.out.println(backLink);
            System.out.println(";-----");
            throw new AssertionError();
        });
    }

    static <T> void processLeaks(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor2) throws AssertionError {
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        ApplicationManager.getApplication().runReadAction(() -> DebugReflectionUtil.walkObjects((int)10000, (Collection)roots, (Class)suspectClass, SHOULD_EXAMINE_VALUE, (value2, backLink) -> {
            Object leaked = value2;
            if (isReallyLeak == null || isReallyLeak.value(leaked)) {
                return processor2.process(leaked, backLink);
            }
            return true;
        }));
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        LeakHunter.checkLeak(Collections.singletonList(root), suspectClass, isReallyLeak);
    }

    @NotNull
    public static List<Object> allRoots() {
        ClassLoader classLoader = LeakHunter.class.getClassLoader();
        Vector allLoadedClasses = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
        return Arrays.asList(ApplicationManager.getApplication(), Disposer.getTree(), IdeEventQueue.getInstance(), LaterInvocator.getLaterInvocatorQueue(), ThreadTracker.getThreads(), allLoadedClasses);
    }
}

