/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    private static LightProjectDescriptor ourProjectDescriptor;
    private ThreadTracker myThreadTracker;
    private static int ourTestCount;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    @NotNull
    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        return ourPsiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        ourApplication = IdeaTestApplication.getInstance();
        return ourApplication;
    }

    public static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)ourApplication));
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) throws Exception {
        ourProjectDescriptor = descriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        File projectFile = FileUtil.createTempFile((String)"light_temp", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        ourProject = PlatformTestCase.createProject(projectFile, LIGHT_PROJECT_MARK + buffer);
        ourPathToKeep = projectFile.getPath();
        ourPsiManager = null;
        ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

            @Override
            public void moduleCreated(@NotNull Module module2) {
                ourModule = module2;
            }

            @Override
            public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                ourSourceRoot = sourceRoot;
            }
        });
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).storePointers();
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            LightPlatformTestCase.initApplication();
            ApplicationInfoImpl.setInStressTest(this.isStressTest());
            ourApplication.setDataProvider(this);
            LightProjectDescriptor descriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors(LightPlatformTestCase.getProject());
            this.storeSettings();
            CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            VirtualFilePointerManagerImpl filePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
            filePointerManager.storePointers();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK());
    }

    public static void doSetup(@NotNull LightProjectDescriptor descriptor, @NotNull LocalInspectionTool[] localInspectionTools, @NotNull Disposable parentDisposable) throws Exception {
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean reusedProject = true;
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
            reusedProject = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        projectManagerEx.openTestProject(ourProject);
        if (reusedProject) {
            DumbService.getInstance((Project)ourProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(ourProject));
        }
        MessageBusConnection connection = ourProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                TestCase.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, LightPlatformTestCase.getProject(), parentDisposable);
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx(LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(((FileDocumentManagerImpl)manager)::dropAllUnsavedDocuments);
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        InspectionsKt.enableInspectionTools(LightPlatformTestCase.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), tool, this.getTestRootDisposable());
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = LightPlatformTestCase.getProject();
        new RunAll(() -> CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings(), this::checkForSettingsDamage, () -> LightPlatformTestCase.doTearDown(project2, ourApplication), () -> LightPlatformTestCase.checkEditorsReleased(), () -> super.tearDown(), () -> this.myThreadTracker.checkLeak(), () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2), () -> ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).assertPointersAreDisposed()).run();
    }

    public static void doTearDown(@NotNull Project project2, @NotNull IdeaTestApplication application) throws Exception {
        new RunAll(new ThrowableRunnable[0]).append(() -> ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue()).append(() -> CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings()).append(LightPlatformTestCase::checkJavaSwingTimersAreDisposed).append(() -> UsefulTestCase.doPostponedFormatting(project2)).append(() -> LookupManager.getInstance(project2).hideActiveLookup()).append(() -> ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).prepareForNextTest()).append(() -> {
            if (ProjectManager.getInstance() == null) {
                throw new AssertionError((Object)"Application components damaged");
            }
        }).append(() -> WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            FileDocumentManager manager;
            EncodingManager encodingManager;
            if (ourSourceRoot != null) {
                try {
                    for (VirtualFile child : ourSourceRoot.getChildren()) {
                        child.delete(LightPlatformTestCase.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((encodingManager = EncodingManager.getInstance()) instanceof EncodingManagerImpl) {
                ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
            }
            if ((manager = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
            }
        })).append(() -> LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed())).append(() -> {
            if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> LightPlatformTestCase.clearUncommittedDocuments(project2)).append(() -> ((HintManagerImpl)HintManager.getInstance()).cleanup()).append(() -> DocumentCommitThread.getInstance().clearQueue()).append(() -> ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests()).append(() -> ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests()).append(() -> ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest()).append(() -> TemplateDataLanguageMappings.getInstance(project2).cleanupForNextTest()).append(() -> ProjectManagerEx.getInstanceEx().closeTestProject(project2)).append(() -> application.setDataProvider(null)).append(() -> {
            ourTestCase = null;
        }).append(() -> ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest()).append(() -> CompletionProgressIndicator.cleanupForNextTest()).append(() -> {
            if (ourTestCount++ % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }).run();
    }

    private static void checkJavaSwingTimersAreDisposed() throws Exception {
        Method sharedInstance;
        Object timerQueue;
        Class<?> TimerQueueClass = Class.forName("javax.swing.TimerQueue");
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(TimerQueueClass, (Object)(timerQueue = (sharedInstance = ReflectionUtil.getMethod(TimerQueueClass, (String)"sharedInstance", (Class[])new Class[0])).invoke(null, new Object[0])), DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer != null) {
            long delay = timer.getDelay(TimeUnit.MILLISECONDS);
            String text = "(delayed for " + delay + "ms)";
            Method getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
            Timer swingTimer = (Timer)getTimer.invoke(timer, new Object[0]);
            text = "Timer (listeners: " + Arrays.asList(swingTimer.getActionListeners()) + ") " + text;
            throw new AssertionFailedError("Not disposed java.swing.Timer: " + text + "; queue:" + timerQueue);
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        new RunAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            RunAll runAll = new RunAll(new ThrowableRunnable[0]);
            for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError(editor)).append(() -> EditorFactory.getInstance().releaseEditor(editor));
            }
            runAll.run();
        }).run();
    }

    @Override
    public final void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                ourTestThread = Thread.currentThread();
                this.startRunAndTear();
            }
            finally {
                ourTestThread = null;
                try {
                    Application application = ApplicationManager.getApplication();
                    if (application instanceof ApplicationEx) {
                        PlatformTestCase.cleanupApplicationCaches(ourProject);
                    }
                    this.resetAllFields();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }));
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String dataId) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    @NotNull
    protected static PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    @NotNull
    protected static PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void commitDocument(@NotNull Document document) {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)LightPlatformTestCase.getProject());
    }

    protected static Document getDocument(@NotNull PsiFile file2) {
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file2);
    }

    public static synchronized void closeAndDeleteProject() {
        File parent;
        if (ourProject == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!ourProject.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)ourProject, (Object)ourModule.getProject());
            File ioFile = new File(ourProject.getProjectFilePath());
            if (ioFile.exists()) {
                File dir = ioFile.getParentFile();
                if (dir.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)dir);
                } else {
                    FileUtil.delete((File)ioFile);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().closeAndDispose(ourProject));
        LightPlatformTestCase.assertTrue((boolean)ourProject.isDisposed());
        if (ourPathToKeep != null && (parent = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
            parent.delete();
        }
        ourProject = null;
        LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
        ourModule = null;
        LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
        ourPsiManager = null;
        ourPathToKeep = null;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleType.equals((Object)that.myModuleType)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            Object[] myUrls = this.mySdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            Object[] newUrls = newSdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            return ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls));
        }
    }
}

