/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();
    protected static final String TEST_MODULE_NAME = "light_idea_test_case";

    public void setUpProject(@NotNull Project project2, @NotNull SetupHandler handler2) throws Exception {
        WriteAction.run(() -> {
            Module module2 = this.createMainModule(project2);
            handler2.moduleCreated(module2);
            VirtualFile sourceRoot = this.createSourcesRoot(module2);
            if (sourceRoot != null) {
                handler2.sourceRootCreated(sourceRoot);
                this.createContentEntry(module2, sourceRoot);
            }
        });
    }

    @NotNull
    public Module createMainModule(@NotNull Project project2) {
        return this.createModule(project2, FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), "light_idea_test_case.iml"}));
    }

    protected Module createModule(@NotNull Project project2, @NotNull String moduleFilePath) {
        return (Module)WriteAction.compute(() -> {
            File imlFile = new File(moduleFilePath);
            if (imlFile.exists()) {
                FileUtil.delete((File)imlFile);
            }
            return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, this.getModuleType().getId());
        });
    }

    @NotNull
    public ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    @Nullable
    public VirtualFile createSourcesRoot(@NotNull Module module2) {
        return this.createSourceRoot(module2, "src");
    }

    protected VirtualFile createSourceRoot(@NotNull Module module2, String srcPath) {
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        VirtualFile srcRoot = this.doCreateSourceRoot(dummyRoot, srcPath);
        this.registerSourceRoot(module2.getProject(), srcRoot);
        return srcRoot;
    }

    protected VirtualFile doCreateSourceRoot(VirtualFile root, String srcPath) {
        VirtualFile srcRoot;
        try {
            srcRoot = root.createChildDirectory((Object)this, srcPath);
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return srcRoot;
    }

    protected void registerSourceRoot(final Project project2, final VirtualFile srcRoot) {
        IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file2) {
                return file2.getFileSystem() == srcRoot.getFileSystem() && project2.isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        iterator.processFile(file2);
                        return true;
                    }
                });
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)project2, () -> FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet));
    }

    protected void createContentEntry(@NotNull Module module2, @NotNull VirtualFile srcRoot) {
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            Sdk sdk = this.getSdk();
            if (sdk != null) {
                model.setSdk(sdk);
            }
            ContentEntry contentEntry = model.addContentEntry(srcRoot);
            contentEntry.addSourceFolder(srcRoot, this.getSourceRootType());
            this.configureModule(module2, (ModifiableRootModel)model, contentEntry);
        });
    }

    @NotNull
    protected JpsModuleSourceRootType<?> getSourceRootType() {
        return JavaSourceRootType.SOURCE;
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile(this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
    }

    public static interface SetupHandler {
        default public void moduleCreated(@NotNull Module module2) {
        }

        default public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
        }
    }
}

