/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.util.Disposer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;
    private boolean myMirrorToStderr = true;

    @NotNull
    public static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    public static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public void processWarn(String message2, Throwable t, @NotNull Logger logger) {
        logger.warn((Object)message2, t);
    }

    public void processError(String message2, Throwable t, String[] details, @NotNull Logger logger) {
        message2 = message2 + DefaultLogger.attachmentsToString((Throwable)t);
        logger.info((Object)message2, t);
        if (this.myMirrorToStderr) {
            System.err.println("ERROR: " + message2);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            if (details != null && details.length > 0) {
                System.out.println("details: ");
                for (String detail : details) {
                    System.out.println(detail);
                }
            }
        }
        throw new AssertionError(message2, t);
    }

    public void disableStderrDumping(@NotNull Disposable parentDisposable) {
        boolean prev = this.myMirrorToStderr;
        this.myMirrorToStderr = false;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myMirrorToStderr = prev;
        });
    }

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor();
    }
}

