/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        super(logger);
    }

    public void warn(String message2, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message2, t, this.myLogger);
    }

    public void error(String message2, @Nullable Throwable t, String ... details) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message2, t, details, this.myLogger);
    }

    public void debug(@NonNls String message2) {
        super.debug(message2);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, null);
    }

    public void debug(@Nullable Throwable t) {
        super.debug(t);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t);
    }

    public void debug(@NonNls String message2, @Nullable Throwable t) {
        super.debug(message2, t);
        TestLoggerFactory.log(this.myLogger, Level.DEBUG, message2, t);
    }

    public void info(@NonNls String message2) {
        super.info(message2);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, null);
    }

    public void info(@NonNls String message2, @Nullable Throwable t) {
        super.info(message2, t);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message2, t);
    }

    public boolean isDebugEnabled() {
        return true;
    }
}

