/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String ORIGINAL_TEMP_DIR;
    private static final Map<String, Long> TOTAL_SETUP_COST_MILLIS;
    private static final Map<String, Long> TOTAL_TEARDOWN_COST_MILLIS;
    @NotNull
    private final Disposable myTestRootDisposable = new TestDisposable();
    static String ourPathToKeep;
    private final List<String> myPathsToKeep = new ArrayList<String>();
    private CodeStyleSettings myOldCodeStyleSettings;
    private CodeInsightSettings myOldCodeInsightSettings;
    private String myTempDir;
    static final Key<String> CREATION_PLACE;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class DELETE_ON_EXIT_HOOK_CLASS;
    @Deprecated
    public static final String IDEA_MARKER_CLASS = "com.intellij.openapi.roots.IdeaModifiableModelsProvider";

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            String testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
            if (StringUtil.isEmptyOrSpaces((String)testName)) {
                testName = "";
            }
            testName = new File(testName).getName();
            this.myTempDir = new File(ORIGINAL_TEMP_DIR, TEMP_DIR_MARKER + testName).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir);
        }
        boolean isStressTest = this.isStressTest();
        ApplicationInfoImpl.setInStressTest(isStressTest);
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        try {
            new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.cleanupSwingDataStructures(), () -> UsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
                if (this.shouldContainTempFiles()) {
                    FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                    if (this.hasTmpFilesToKeep()) {
                        File[] files = new File(this.myTempDir).listFiles();
                        if (files != null) {
                            for (File file2 : files) {
                                if (this.shouldKeepTmpFile(file2)) continue;
                                FileUtil.delete((File)file2);
                            }
                        }
                    } else {
                        FileUtil.delete((File)new File(this.myTempDir));
                    }
                }
            }, () -> UIUtil.removeLeakingAppleListeners()).run();
        }
        finally {
            super.tearDown();
        }
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file2) {
        this.myPathsToKeep.add(file2.getPath());
    }

    private boolean hasTmpFilesToKeep() {
        return ourPathToKeep != null && FileUtil.isAncestor((String)this.myTempDir, (String)ourPathToKeep, (boolean)false) || !this.myPathsToKeep.isEmpty();
    }

    private boolean shouldKeepTmpFile(@NotNull File file2) {
        String path = file2.getPath();
        if (FileUtil.pathsEqual((String)path, (String)ourPathToKeep)) {
            return true;
        }
        for (String pathToKeep : this.myPathsToKeep) {
            if (!FileUtil.pathsEqual((String)path, (String)pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> list;
        Class clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            String path = (String)list.get(i2);
            File file2 = new File(path);
            if (!file2.delete() && file2.exists()) continue;
            Class clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    protected void checkForSettingsDamage() {
        Application app = ApplicationManager.getApplication();
        if (this.isStressTest() || app == null || app instanceof MockApplication) {
            return;
        }
        CodeInsightSettings oldCodeInsightSettings = this.myOldCodeInsightSettings;
        if (oldCodeInsightSettings == null) {
            return;
        }
        this.myOldCodeInsightSettings = null;
        UsefulTestCase.checkForInsightSettingsDamage(oldCodeInsightSettings, CodeInsightSettings.getInstance());
        CodeStyleSettings oldCodeStyleSettings = this.myOldCodeStyleSettings;
        if (oldCodeStyleSettings == null) {
            return;
        }
        this.myOldCodeStyleSettings = null;
        UsefulTestCase.checkForStyleSettingsDamage(oldCodeStyleSettings, this.getCurrentCodeStyleSettings());
    }

    public static void checkForInsightSettingsDamage(@NotNull CodeInsightSettings oldCodeInsightSettings, @NotNull CodeInsightSettings currentCodeInsightSettings) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                Element newS = new Element("temp");
                settings.writeExternal(newS);
                Assert.assertEquals((String)"Code insight settings damaged", (Object)JDOMUtil.writeElement((Element)oldCodeInsightSettings.getState(), (String)"\n"), (Object)JDOMUtil.writeElement((Element)currentCodeInsightSettings.getState(), (String)"\n"));
            }
            catch (AssertionError error) {
                for (Field field : oldCodeInsightSettings.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)oldCodeInsightSettings, (Object)settings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw error;
            }
        }).run();
    }

    public static void checkForStyleSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            currentCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                UsefulTestCase.checkSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).append(() -> InplaceRefactoring.checkCleared()).append(() -> StartMarkAction.checkCleared()).run();
    }

    void storeSettings() {
        if (!this.isStressTest() && ApplicationManager.getApplication() != null) {
            this.myOldCodeStyleSettings = this.getCurrentCodeStyleSettings().clone();
            this.myOldCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            this.myOldCodeInsightSettings = CodeInsightSettings.getInstance().clone();
        }
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getInstance().getCurrentSettings();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        Runnable runnable2 = () -> {
            try {
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e;
            }
            catch (Throwable e) {
                TestLoggerFactory.onTestFinished(false);
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable2);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        return PlatformTestUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable2) throws Exception {
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            runnable2.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defaultRunBare() throws Throwable {
        Throwable exception = null;
        try {
            long setupStart = System.nanoTime();
            this.setUp();
            long setupCost = (System.nanoTime() - setupStart) / 1000000L;
            this.logPerClassCost(setupCost, TOTAL_SETUP_COST_MILLIS);
            this.runTest();
        }
        catch (Throwable running) {
            exception = running;
        }
        finally {
            block13: {
                try {
                    long teardownStart = System.nanoTime();
                    this.tearDown();
                    long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                    this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                }
                catch (Throwable tearingDown) {
                    if (exception != null) break block13;
                    exception = tearingDown;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void logPerClassCost(long cost, @NotNull Map<String, Long> costMap) {
        Class<?> superclass = ((Object)((Object)this)).getClass().getSuperclass();
        Long oldCost = costMap.get(superclass.getName());
        long newCost = oldCost == null ? cost : oldCost + cost;
        costMap.put(superclass.getName(), newCost);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_SETUP_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalSetup += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_TEARDOWN_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalTeardown += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", totalSetup, totalTeardown));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", totalSetup));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", totalTeardown));
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestRunnerUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> runnable2) {
        EdtTestUtil.runInEdtAndWait(runnable2);
    }

    public static String toString(@NotNull Iterable<?> collection) {
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((THashSet)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual, @NotNull byte[] expected) {
        UsefulTestCase.assertEquals((int)actual.length, (int)expected.length);
        for (int i2 = 0; i2 < actual.length; ++i2) {
            byte a = actual[i2];
            byte e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] actual, @NotNull int[] expected) {
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            int a = actual[i2];
            int e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Collection<? extends T> expected) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : actual) {
            list.add(t);
        }
        if (!list.equals(new ArrayList<T>(expected))) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] collection, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(collection), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertSameElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        UsefulTestCase.assertSameElements(null, collection, expected);
    }

    public static <T> void assertSameElements(String message2, @NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        if (collection.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(collection))) {
            Assert.assertEquals((String)message2, (Object)UsefulTestCase.toString(expected, "\n"), (Object)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals((String)message2, new HashSet<T>(expected), new HashSet<T>(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertOrderedEquals(UsefulTestCase.toString(collection), copy, expected);
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(@NotNull Object[] collection, @NotNull String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<T> notExpected) {
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i2 = 0;
        for (T actual : collection) {
            try {
                checkers[i2].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i2 + ": " + actual);
                throw e;
            }
            ++i2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i2 = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer2 : checkerSet) {
                Throwable error = UsefulTestCase.accepts(consumer2, actual);
                if (error == null) {
                    checkerSet.remove(consumer2);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i2 + "): " + actual));
            }
            ++i2;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<T> condition2, T actual) {
        try {
            condition2.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(@NotNull Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        String toString = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator.hasNext());
        T t = iterator.next();
        Assert.assertFalse((String)toString, (boolean)iterator.hasNext());
        return t;
    }

    public static <T> T assertOneElement(@NotNull T[] ts) {
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value2, T ... values) {
        boolean found = false;
        for (T v : values) {
            if (value2 != v && (value2 == null || !value2.equals(v))) continue;
            found = true;
        }
        Assert.assertTrue((String)(value2 + " should be equal to one of " + Arrays.toString(values)), (boolean)found);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole("Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(String errorMsg, Collection<T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object[] array) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
    }

    public static void assertSize(int expectedSize, Collection<?> c) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        return disposable;
    }

    public static void assertSameLines(String expected, String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file2) {
        UsefulTestCase.assertTrue((String)("File should exist " + file2), (boolean)file2.exists());
    }

    public static void assertDoesntExist(@NotNull File file2) {
        UsefulTestCase.assertFalse((String)("File should not exist " + file2), (boolean)file2.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(String name, boolean lowercaseFirstLetter) {
        return name == null ? "" : PlatformTestUtil.getTestName(name, lowercaseFirstLetter);
    }

    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(String filePath, String actualText) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(String filePath, String actualText, boolean trimBeforeComparing) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Comparing.equal((String)expected, (String)actual)) {
            throw new FileComparisonFailure(null, expected, actual, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(Object test, Class aClass) throws IllegalAccessException {
        if (aClass == null) {
            return;
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkSettingsEqual(CodeStyleSettings expected, CodeStyleSettings settings) throws Exception {
        if (expected == null || settings == null) {
            return;
        }
        Element oldS = new Element("temp");
        expected.writeExternal(oldS);
        Element newS = new Element("temp");
        settings.writeExternal(newS);
        String newString = JDOMUtil.writeElement((Element)newS, (String)"\n");
        String oldString = JDOMUtil.writeElement((Element)oldS, (String)"\n");
        Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getName();
        return UsefulTestCase.isPerformanceTest(testName, className);
    }

    public static boolean isPerformanceTest(@Nullable String testName, @Nullable String className) {
        return testName != null && StringUtil.containsIgnoreCase((String)testName, (String)"performance") || className != null && StringUtil.containsIgnoreCase((String)className, (String)"performance");
    }

    public boolean isStressTest() {
        return UsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return UsefulTestCase.isPerformanceTest(testName, className) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance(project2).doPostponedFormatting();
        });
    }

    protected void assertException(AbstractExceptionCase exceptionCase) throws Throwable {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) throws Throwable {
        UsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    protected <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable2) throws T {
        this.assertThrows(exceptionClass, null, runnable2);
    }

    protected <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsg, final @NotNull ThrowableRunnable<T> runnable2) throws T {
        UsefulTestCase.assertExceptionOccurred(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return exceptionClass;
            }

            @Override
            public void tryClosure() throws Throwable {
                runnable2.run();
            }
        }, expectedErrorMsg);
    }

    protected <T extends Throwable> void assertNoException(AbstractExceptionCase<T> exceptionCase) throws T {
        UsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void assertExceptionOccurred(boolean shouldOccur, AbstractExceptionCase<T> exceptionCase, String expectedErrorMsg) throws T {
        block9: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                if (shouldOccur) {
                    wasThrown = true;
                    String errorMessage = exceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)errorMessage, exceptionCase.getExpectedExceptionClass(), e.getClass());
                    if (expectedErrorMsg != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)expectedErrorMsg, (String)e.getMessage());
                    }
                    break block9;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(e.getClass())) {
                    wasThrown = true;
                    System.out.println("");
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + e.getMessage()));
                    break block9;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)exceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method2;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method2 = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method2.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile file2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                file2.getChildren();
                return true;
            }
        });
        file2.refresh(false, true);
    }

    @NotNull
    public static Test filteredSuite(@RegExp String regexp, @NotNull Test test) {
        final Pattern pattern = Pattern.compile(regexp);
        final TestSuite testSuite = new TestSuite();
        new Processor<Test>(){

            public boolean process(Test test) {
                if (test instanceof TestSuite) {
                    int len = ((TestSuite)test).testCount();
                    for (int i2 = 0; i2 < len; ++i2) {
                        this.process(((TestSuite)test).testAt(i2));
                    }
                } else if (pattern.matcher(test.toString()).find()) {
                    testSuite.addTest(test);
                }
                return false;
            }
        }.process(test);
        return testSuite;
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(@NotNull File file2) {
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new HashMap();
        TOTAL_TEARDOWN_COST_MILLIS = new HashMap();
        Logger.setFactory(TestLoggerFactory.class);
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    public class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

