/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> '\"' + intentionAction.getText() + '\"';
    private static final String RAINBOW = "rainbow";
    private static final String FOLD = "fold";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private boolean myEmptyLookup;
    private VirtualFileFilter myVirtualFileFilter = new FileTreeAccessFilter();
    private ChooseByNameBase myChooseByNamePopup;
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection = true;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, @NotNull SortedMap<Integer, List<GutterMark>> result2) {
        if (renderer == null) {
            return;
        }
        List renderers = (List)result2.get(offset);
        if (renderers == null) {
            renderers = new SmartList();
            result2.put(offset, renderers);
        }
        renderers.add(renderer);
    }

    private static void removeDuplicatedRangesForInjected(@NotNull List<HighlightInfo> infos) {
        Collections.sort(infos, (o1, o2) -> {
            int i2 = o2.startOffset - o1.startOffset;
            return i2 != 0 ? i2 : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull int[] toIgnore, boolean canChangeDocument) {
        Project project2 = file2.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        ProcessCanceledException exception = null;
        for (int i2 = 0; i2 < 1000; ++i2) {
            int oldDelay = settings.AUTOREPARSE_DELAY;
            try {
                settings.AUTOREPARSE_DELAY = 0;
                List<HighlightInfo> infos = codeAnalyzer.runPasses(file2, editor.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx(project2).getFileLevelHighlights(project2, file2));
                List<HighlightInfo> list = infos;
                return list;
            }
            catch (ProcessCanceledException e) {
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                UIUtil.dispatchAllInvocationEvents();
                exception = e;
                continue;
            }
            finally {
                settings.AUTOREPARSE_DELAY = oldDelay;
            }
        }
        throw exception;
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (!DumbService.isDumb((Project)project2)) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, null);
            FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project2, null);
        }
    }

    @NotNull
    public static List<IntentionAction> getAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        return (List)ReadAction.compute(() -> CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file2));
    }

    @NotNull
    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file2, intentions, -1);
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, intentions, editor, file2, file2.getProject());
        for (Map.Entry<IntentionAction, List<IntentionAction>> entry : intentionListStep.getActionsWithSubActions().entrySet()) {
            result2.add(entry.getKey());
            result2.addAll((Collection)entry.getValue());
        }
        List<HighlightInfo> infos = DaemonCodeAnalyzerEx.getInstanceEx(file2.getProject()).getFileLevelHighlights(file2.getProject(), file2);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (!actionInGroup.getAction().isAvailable(file2.getProject(), editor, file2)) continue;
                result2.add(actionInGroup.getAction());
                List<IntentionAction> options = actionInGroup.getOptions((PsiElement)file2, editor);
                if (options == null) continue;
                for (IntentionAction subAction : options) {
                    if (!subAction.isAvailable(file2.getProject(), editor, file2)) continue;
                    result2.add(subAction);
                }
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return this.myTempDirFixture.getTempDirPath();
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        return this.myTempDirFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        return this.copyFileToProject(sourcePath, sourcePath);
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        String testDataPath = this.getTestDataPath();
        File sourceFile = FileUtil.findFirstThatExist((String[])new String[]{testDataPath + '/' + sourcePath, sourcePath});
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (sourceFile == null && targetFile != null && targetPath.equals(sourcePath)) {
            return targetFile;
        }
        Assert.assertNotNull((String)("Cannot find source file: " + sourcePath + "; test data path: " + testDataPath), (Object)sourceFile);
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)sourceFile.getAbsolutePath());
        }
        final File _source = sourceFile;
        final VirtualFile _target = targetFile;
        new WriteAction(){

            protected void run(@NotNull Result result2) throws IOException {
                _target.setBinaryContent(FileUtil.loadFileBytes((File)_source));
            }
        }.execute();
        return targetFile;
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file2);
        file2.refresh(false, true);
        return file2;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), inspections);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        List<InspectionProfileEntry> tools = InspectionTestUtil.instantiateTools(inspections);
        this.enableInspections(tools.toArray(new InspectionProfileEntry[tools.size()]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.getProject()).getCurrentProfile();
        for (InspectionProfileEntry inspection : inspections) {
            profile2.disableTool(inspection.getShortName(), this.getProject());
        }
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        List<Class<? extends LocalInspectionTool>> classes2 = Stream.of(providers).flatMap(p -> Stream.of(p.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).map(c -> {
            Class toolClass = c;
            return toolClass;
        }).collect(Collectors.toList());
        this.enableInspections(classes2);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... paths) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(paths).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(files));
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, Stream<VirtualFile> files) {
        List data = files.map(file2 -> {
            PsiFile psiFile = this.myPsiManager.findFile((VirtualFile)file2);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData datum = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, psiFile);
            datum.init();
            return Trinity.create((Object)psiFile, (Object)this.createEditor((VirtualFile)file2), (Object)datum);
        }).collect(Collectors.toList());
        long elapsed = 0L;
        for (Trinity trinity : data) {
            this.myEditor = (Editor)trinity.second;
            this.myFile = ((PsiFile)trinity.first).getVirtualFile();
            elapsed += this.collectAndCheckHighlighting((ExpectedHighlightingData)trinity.third);
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file2) {
        this.openFileInEditor(file2);
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        return new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, CodeInsightTestFixtureImpl.this.getFile());
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file2) {
        this.myFile = file2;
        this.myEditor = this.createEditor(file2);
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper toolWrapper) {
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "src");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool(scope, this.getProject(), Collections.singletonList(toolWrapper));
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults(globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found at " + this.myEditor.getCaretModel().getLogicalPosition()), (Object)reference);
        return reference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getAvailableIntentions();
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                actions.add(((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction());
            }
        }
        return actions;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        PsiFile file2 = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        }
        Assert.assertNotNull((Object)file2);
        return CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file2);
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        return this.getAvailableIntentions().stream().filter(action -> action.getText().startsWith(hint)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        List<IntentionAction> list = this.filterAvailableIntentions(hint);
        if (list.isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        return UsefulTestCase.assertOneElement(list);
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        List<IntentionAction> intentions = this.getAvailableIntentions(filePaths);
        IntentionAction action = CodeInsightTestUtil.findIntentionByText(intentions, intentionName);
        if (action == null) {
            System.out.println(intentionName + " not found among " + StringUtil.join(intentions, IntentionAction::getText, (String)","));
        }
        return action;
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        CodeInsightTestFixtureImpl.invokeIntention(action, this.getFile(), this.getEditor(), action.getText());
    }

    @Override
    public void testCompletion(@NotNull String[] filesBefore, @NotNull String fileAfter) {
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(@NotNull String[] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)((Object)this.myPsiManager));
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull String fileBefore, @NotNull String toType, @NotNull String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        this.assertInitialized();
        List<String> result2 = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result2);
        UsefulTestCase.assertSameElements(result2, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, LookupElement::getLookupString);
    }

    @Override
    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.getEditor());
            Assert.assertNotNull((Object)lookup);
            lookup.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), command, null, null);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        Editor editor = this.getCompletionEditor();
        int findTargetFlags = 3;
        PsiElement element = TargetElementUtil.findTargetElement(editor, findTargetFlags);
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement(((EditorWindow)editor).getDelegate(), findTargetFlags);
        }
        if (element == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), true, true)));
        }
        return element;
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName) {
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(final @NotNull String newName) {
        final DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context = new DataContext(){

            public Object getData(String dataId) {
                return PsiElementRenameHandler.DEFAULT_NAME.getName().equals(dataId) ? newName : editorContext.getData(dataId);
            }
        };
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, this.myEditor);
        if (substitution == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text);
        Assert.assertTrue((String)text, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @Override
    public void type(char c) {
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            if (c == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c == '\n') {
                if (this._performEditorAction("EditorChooseLookupItem")) {
                    return;
                }
                if (this._performEditorAction("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c == '\t') {
                if (this._performEditorAction("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this._performEditorAction("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this._performEditorAction("NextTemplateVariable")) {
                    return;
                }
                if (this._performEditorAction("EditorTab")) {
                    return;
                }
            }
            if (c == '\r' && this._performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                CommandProcessor.getInstance().setCurrentCommandGroupId((Object)this.myEditor.getDocument());
                ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, this.getEditorDataContext());
                actionManager.getTypedAction().actionPerformed(this.getEditor(), c, this.getEditorDataContext());
            }, null, (Object)DocCommandGroupId.noneGroupId((Document)this.myEditor.getDocument()));
        });
    }

    @NotNull
    private DataContext getEditorDataContext() {
        return ((EditorEx)this.myEditor).getDataContext();
    }

    @Override
    public void type(@NotNull String s) {
        for (int i2 = 0; i2 < s.length(); ++i2) {
            this.type(s.charAt(i2));
        }
    }

    @Override
    public void performEditorAction(@NotNull String actionId) {
        this.assertInitialized();
        this._performEditorAction(actionId);
    }

    private boolean _performEditorAction(@NotNull String actionId) {
        DataContext dataContext = this.getEditorDataContext();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action = managerEx.getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0);
        action.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            return false;
        }
        managerEx.fireBeforeActionPerformed(action, dataContext, event);
        action.actionPerformed(event);
        managerEx.fireAfterActionPerformed(action, dataContext, event);
        return true;
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        TestActionEvent e = new TestActionEvent(action);
        action.beforeActionPerformedUpdate((AnActionEvent)e);
        if (e.getPresentation().isEnabled() && e.getPresentation().isVisible()) {
            action.actionPerformed((AnActionEvent)e);
        }
        return e.getPresentation();
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        this.assertInitialized();
        this.configureByFiles(fileNames);
        int flags = 3;
        PsiElement targetElement = TargetElementUtil.findTargetElement(this.getEditor(), flags);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        return this.findUsages(targetElement);
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        return this.findUsages(targetElement, null);
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        Project project2 = this.getProject();
        FindUsagesHandler handler2 = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler2);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler2.getPrimaryElements(), (Object[])handler2.getSecondaryElements());
        FindUsagesOptions options = handler2.getFindUsagesOptions(null);
        if (scope != null) {
            options.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler2.processElementUsages(psiElement, (Processor<UsageInfo>)processor2, options);
        }
        return processor2.getResults();
    }

    @Override
    @NotNull
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        this.configureByFiles(files);
        this.testAction(new HighlightUsagesAction());
        Editor editor = this.getEditor();
        return editor.getMarkupModel().getAllHighlighters();
    }

    @Override
    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        this.assertInitialized();
        Project project2 = this.getProject();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath)));
        VirtualFile file2 = this.findFileInTempDir(to);
        Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file2);
        Assert.assertTrue((String)(to + " is not a directory"), (boolean)file2.isDirectory());
        PsiDirectory directory = this.myPsiManager.findDirectory(file2);
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{this.getFile()}, directory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.findGutters((Processor<GutterMark>)processor2);
        return (GutterMark)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.findGutters((Processor<GutterMark>)processor2);
        return new ArrayList<GutterMark>(processor2.getResults());
    }

    private void findGutters(Processor<GutterMark> processor2) {
        RangeHighlighter[] highlighters;
        int offset = this.myEditor.getCaretModel().getOffset();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            GutterMark renderer;
            if (info.endOffset < offset || info.startOffset > offset || (renderer = info.getGutterIconRenderer()) == null || processor2.process((Object)renderer)) continue;
            return;
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true).getAllHighlighters()) {
            GutterIconRenderer renderer;
            if (highlighter.getEndOffset() < offset || highlighter.getStartOffset() > offset || (renderer = highlighter.getGutterIconRenderer()) == null || processor2.process((Object)renderer)) continue;
            return;
        }
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        this.configureByFilesInner(filePath);
        return this.findAllGutters();
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project2 = this.getProject();
        TreeMap<Integer, List<GutterMark>> result2 = new TreeMap<Integer, List<GutterMark>>();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result2);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), project2, true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result2);
        }
        return ContainerUtil.concat(result2.values());
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(final @NotNull String rootPath, final @NotNull String relativePath, final @NotNull String fileText) {
        return (PsiFile)new WriteCommandAction<PsiFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<PsiFile> result2) throws Throwable {
                try {
                    if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                        VirtualFile file2 = CodeInsightTestFixtureImpl.this.myTempDirFixture.createFile(relativePath, fileText);
                        result2.setResult((Object)PsiManager.getInstance((Project)this.getProject()).findFile(file2));
                    } else {
                        result2.setResult((Object)((HeavyIdeaTestFixture)CodeInsightTestFixtureImpl.this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.getProject()).getModificationTracker()).incCounter();
                }
            }
        }.execute().getResultObject();
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> epName, final T extension) {
        this.assertInitialized();
        final ExtensionPoint extensionPoint = area.getExtensionPoint(epName);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type2) {
        return this.complete(type2, 1);
    }

    @Override
    public LookupElement[] complete(final @NotNull CompletionType type2, final int invocationCount) {
        this.assertInitialized();
        this.myEmptyLookup = false;
        return (LookupElement[])UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<LookupElement[]>(){

            public LookupElement[] compute() {
                CommandProcessor.getInstance().executeCommand(CodeInsightTestFixtureImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CodeCompletionHandlerBase handler2 = new CodeCompletionHandlerBase(type2){

                            @Override
                            protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                                CodeInsightTestFixtureImpl.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                                super.completionFinished(indicator, hasModifiers);
                            }
                        };
                        Editor editor = CodeInsightTestFixtureImpl.this.getCompletionEditor();
                        Assert.assertNotNull((Object)editor);
                        handler2.invokeCompletion(CodeInsightTestFixtureImpl.this.getProject(), editor, invocationCount);
                        PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).commitAllDocuments();
                    }
                }, null, null);
                return CodeInsightTestFixtureImpl.this.getLookupElements();
            }
        });
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result2.addAll(Arrays.asList(lookupElements));
        }
        return result2;
    }

    @Override
    public void saveText(final @NotNull VirtualFile file2, final @NotNull String text) {
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list = lookup.getItems();
        return list.toArray(new LookupElement[list.size()]);
    }

    @Override
    public void checkResult(@NotNull String text) {
        this.checkResult(text, false);
    }

    @Override
    public void checkResult(final @NotNull String text, final boolean stripTrailingSpaces) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                EditorUtil.fillVirtualSpaceUntilCaret(CodeInsightTestFixtureImpl.this.myEditor);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text), CodeInsightTestFixtureImpl.this.getHostFile().getText());
            }
        }.execute();
    }

    @Override
    public void checkResult(final @NotNull String filePath, final @NotNull String text, final boolean stripTrailingSpaces) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.getFileToCheck(filePath);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text), psiFile.getText());
            }
        }.execute();
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded(() -> this.checkResultByFile(expectedFile, this.getHostFile(), ignoreTrailingWhitespaces));
    }

    @Override
    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded(() -> this.checkResultByFile(expectedFile, this.getFileToCheck(filePath), ignoreTrailingWhitespaces));
    }

    private PsiFile getFileToCheck(String filePath) {
        String path = filePath.replace(File.separatorChar, '/');
        VirtualFile copy = this.findFileInTempDir(path);
        Assert.assertNotNull((String)("could not find results file " + path), (Object)copy);
        PsiFile psiFile = this.myPsiManager.findFile(copy);
        Assert.assertNotNull((String)copy.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            this.myProjectFixture.setUp();
            this.myTempDirFixture.setUp();
            VirtualFile tempDir = this.myTempDirFixture.getFile("");
            Assert.assertNotNull((Object)tempDir);
            PlatformTestCase.synchronizeTempDirVfs(tempDir);
            this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
            InspectionsKt.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            daemonCodeAnalyzer.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            ((StartupManagerImpl)StartupManagerEx.getInstanceEx(this.getProject())).runPostStartupActivities();
        }));
    }

    @Override
    public void tearDown() throws Exception {
        try {
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                try {
                    DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
                    FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
                    PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    for (VirtualFile openFile2 : editorManager.getOpenFiles()) {
                        editorManager.closeFile(openFile2);
                    }
                }
                finally {
                    this.myEditor = null;
                    this.myFile = null;
                    this.myPsiManager = null;
                    this.myChooseByNamePopup = null;
                    try {
                        this.myProjectFixture.tearDown();
                    }
                    finally {
                        this.myTempDirFixture.tearDown();
                    }
                }
            }));
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    private PsiFile[] configureByFilesInner(String ... filePaths) {
        this.assertInitialized();
        this.myFile = null;
        this.myEditor = null;
        PsiFile[] psiFiles2 = new PsiFile[filePaths.length];
        for (int i2 = filePaths.length - 1; i2 >= 0; --i2) {
            psiFiles2[i2] = this.configureByFileInner(filePaths[i2]);
        }
        return psiFiles2;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file2) {
        this.configureByFilesInner(file2);
        return this.getFile();
    }

    @Override
    @NotNull
    public PsiFile[] configureByFiles(String ... files) {
        return this.configureByFilesInner(files);
    }

    @Override
    public PsiFile configureByText(final @NotNull FileType fileType, @NotNull String text) {
        this.assertInitialized();
        final String extension = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Exception {
                    fileTypeManager.associateExtension(fileType, extension);
                }
            }.execute();
        }
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text);
    }

    @Override
    public PsiFile configureByText(final @NotNull String fileName, final @NotNull String text) {
        this.assertInitialized();
        VirtualFile vFile = (VirtualFile)new WriteCommandAction<VirtualFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                VirtualFile vFile;
                if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    vFile = root.findOrCreateChildData((Object)this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)vFile);
                } else if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    File tempFile = ((TempDirTestFixtureImpl)CodeInsightTestFixtureImpl.this.myTempDirFixture).createTempFile(fileName);
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
                    Assert.assertNotNull((String)(tempFile + " not found"), (Object)vFile);
                } else {
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(CodeInsightTestFixtureImpl.this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + CodeInsightTestFixtureImpl.this.getTempDirPath()), (Object)vFile);
                }
                CodeInsightTestFixtureImpl.this.prepareVirtualFile(vFile);
                Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
                result2.setResult((Object)vFile);
            }
        }.execute().getResultObject();
        this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
        return this.getFile();
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        this.assertInitialized();
        VirtualFile file2 = this.copyFileToProject(filePath);
        return this.configureByFileInner(file2);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        VirtualFile fileInTempDir = this.findFileInTempDir(filePath);
        if (fileInTempDir == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        this.configureByFileInner(virtualFile);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy) {
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(@NotNull VirtualFile copy, @NotNull SelectionAndCaretMarkupLoader loader) {
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (!copy.getFileType().isBinary()) {
                try {
                    WriteAction.run(() -> copy.setBinaryContent(loader.newFileText.getBytes(copy.getCharset())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.myFile = copy;
            this.myEditor = this.createEditor(copy);
            if (this.myEditor == null) {
                Assert.fail((String)("editor couldn't be created for: " + copy.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.myEditor, loader.caretState);
            Module module2 = this.getModule();
            if (module2 != null) {
                for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    ((FacetManagerListener)module2.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            if (this.myCaresAboutInjection) {
                this.setupEditorForInjectedLanguage();
            }
        }));
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file2) {
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
        if (editor instanceof EditorWindow) {
            this.myFile = ((EditorWindow)editor).getInjectedFile().getViewProvider().getVirtualFile();
            this.myEditor = editor;
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy, filePath);
        return copy;
    }

    @Nullable
    protected Editor createEditor(@NotNull VirtualFile file2) {
        Project project2 = this.getProject();
        FileEditorManager instance = FileEditorManager.getInstance((Project)project2);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance.openTextEditor(new OpenFileDescriptor(project2, file2), false);
        EditorTestUtil.waitForLoading(editor);
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        }
        return editor;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, this.getHostFile());
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        return InjectedLanguageUtil.getTopLevelFile((PsiElement)this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        Project project2 = this.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFileImpl file2 = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file2.calcTreeElement();
        if (!DumbService.isDumb((Project)project2)) {
            CacheManager.SERVICE.getInstance(project2).getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope((Project)project2), true);
        }
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            PsiManagerEx.getInstanceEx(project2).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult(infos, file2.getText());
        if (data.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            data.checkLineMarkers(DaemonCodeAnalyzerImpl.getLineMarkers(document, this.getProject()), document.getText());
        }
        hardRefToFileElement.hashCode();
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter) {
        this.myVirtualFileFilter = filter;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project2 = this.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        }
        Assert.assertNotNull((Object)file2);
        return CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, ArrayUtil.EMPTY_INT_ARRAY, this.myAllowDirt);
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        return ContainerUtil.filter(this.doHighlighting(), info -> info.getSeverity().compareTo(minimalSeverity) >= 0);
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        return this.myTestDataPath;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        this.myTestDataPath = dataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) {
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        String fileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        String charset = Optional.ofNullable(originalFile.getVirtualFile()).map(f -> f.getCharset().name()).orElse(null);
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), fileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualText) {
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            newFileText1 = this.stripTrailingSpaces(newFileText1);
        }
        if (!Comparing.equal((String)newFileText1, (String)(actualText = StringUtil.convertLineSeparators((String)actualText)))) {
            if (loader.filePath != null) {
                throw new FileComparisonFailure(expectedFile, newFileText1, actualText, loader.filePath);
            }
            throw new ComparisonFailure(expectedFile, newFileText1, actualText);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, loader.caretState, expectedFile);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        actualText = document.getText();
        return actualText;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        CodeFoldingManager.getInstance(this.getProject()).buildInitialFoldings(this.myEditor);
        return CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), Arrays.asList(this.myEditor.getFoldingModel().getAllFoldRegions()), FOLD, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (withCollapseStatus ? " expand='" + foldRegion.isExpanded() + "'" : ""));
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String text, @NotNull Collection<T> segments, @NotNull String tagName, @Nullable Function<T, String> attrCalculator) {
        LinkedList<Border> borders = new LinkedList<Border>();
        for (Segment region : segments) {
            String attr = attrCalculator == null ? null : (String)attrCalculator.fun((Object)region);
            borders.add(new Border(true, region.getStartOffset(), attr));
            borders.add(new Border(false, region.getEndOffset(), ""));
        }
        Collections.sort(borders);
        StringBuilder result2 = new StringBuilder(text);
        for (Border border : borders) {
            StringBuilder info = new StringBuilder();
            info.append('<');
            if (border.isLeftBorder) {
                info.append(tagName);
                if (border.text != null) {
                    info.append(' ').append(border.text);
                }
            } else {
                info.append('/').append(tagName);
            }
            info.append('>');
            result2.insert(border.offset, info);
        }
        return result2.toString();
    }

    private void testFoldingRegions(@NotNull String verificationFileName, @Nullable String destinationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        File verificationFile;
        try {
            verificationFile = new File(verificationFileName);
            expectedContent = FileUtil.loadFile((File)verificationFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = expectedContent.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
        if (destinationFileName == null) {
            this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(verificationFileName), cleanContent);
        } else {
            try {
                FileUtil.writeToFile((File)new File(destinationFileName), (String)cleanContent);
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(destinationFileName);
                Assert.assertNotNull((Object)file2);
                this.configureFromExistingVirtualFile(file2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        if (!expectedContent.equals(actual)) {
            throw new FileComparisonFailure(verificationFile.getName(), expectedContent, actual, verificationFile.getPath());
        }
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        this.testFoldingRegions(verificationFileName, null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        this.testFoldingRegions(verificationFileName, destinationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        this.testFoldingRegions(verificationFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRainbow(@NotNull String fileName, @NotNull String text, boolean isRainbowOn, boolean withColor) {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isRainbowOnInScheme = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)globalScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOn);
            this.configureByText(fileName, text.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List highlighting = ContainerUtil.filter(this.doHighlighting(), info -> info.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)text, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), highlighting, RAINBOW, highlightInfo -> {
                if (!withColor) {
                    return null;
                }
                TextAttributes attributes = highlightInfo.getTextAttributes(null, null);
                String color = attributes == null ? "null" : (attributes.getForegroundColor() == null ? "null" : Integer.toHexString(attributes.getForegroundColor().getRGB()));
                return "color='" + color + "'";
            }));
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, isRainbowOnInScheme);
        }
    }

    @Override
    public void testInlays() {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkInlays();
        }
        finally {
            checker.tearDown();
        }
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List<String> actual = strings.subList(0, Math.min(expected.length, strings.size()));
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights(lookup, false), expected);
        }
        if (selected != list.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights(lookup, false));
        }
        Assert.assertEquals((long)selected, (long)list.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<StructureViewComponent> consumer2) {
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)builder);
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.myProjectFixture.getProject());
            consumer2.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        ChooseByNameBase chooseByNamePopup = this.getMockChooseByNamePopup(contextForSorting);
        ArrayList<Object> results = new ArrayList<Object>();
        chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, chooseByNamePopup.transformPattern(pattern), searchEverywhere, (ProgressIndicator)new MockProgressIndicator(), (Processor<Object>)new CommonProcessors.CollectProcessor(results));
        return results;
    }

    @NotNull
    private ChooseByNameBase getMockChooseByNamePopup(@Nullable PsiElement contextForSorting) {
        Project project2 = this.getProject();
        if (contextForSorting != null) {
            return ChooseByNamePopup.createPopup(project2, (ChooseByNameModel)new GotoClassModel2(project2), contextForSorting);
        }
        if (this.myChooseByNamePopup == null) {
            this.myChooseByNamePopup = ChooseByNamePopup.createPopup(project2, (ChooseByNameModel)new GotoClassModel2(project2), (PsiElement)null);
        }
        return this.myChooseByNamePopup;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.myFile = FileDocumentManager.getInstance().getFile(document);
            this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
        }
    }

    public static boolean invokeIntention(@NotNull IntentionAction action, PsiFile file2, Editor editor, String actionText) {
        ReadonlyStatusHandlerImpl handler2 = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)file2.getProject());
        CodeInsightTestFixtureImpl.setReadOnly(file2, true);
        handler2.setClearReadOnlyInTests(true);
        AtomicBoolean result2 = new AtomicBoolean();
        try {
            ApplicationManager.getApplication().invokeLater(() -> result2.set(ShowIntentionActionsHandler.chooseActionAndInvoke(file2, editor, action, actionText)));
            UIUtil.dispatchAllInvocationEvents();
        }
        catch (AssertionError e) {
            ExceptionUtil.rethrowUnchecked((Throwable)ExceptionUtil.getRootCause((Throwable)((Object)e)));
            throw e;
        }
        finally {
            handler2.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.setReadOnly(file2, false);
        }
        return result2.get();
    }

    private static void setReadOnly(PsiFile file2, boolean readOnlyStatus) {
        try {
            WriteAction.run(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)InjectedLanguageUtil.getTopLevelFile((PsiElement)file2).getVirtualFile(), (boolean)readOnlyStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static GlobalInspectionContextForTests createGlobalContextForTool(@NotNull AnalysisScope scope, @NotNull Project project2, @NotNull InspectionManagerEx inspectionManager, InspectionToolWrapper ... toolWrappers) {
        return InspectionsKt.createGlobalContextForTool(scope, project2, Arrays.asList(toolWrappers));
    }

    private static class Border
    implements Comparable<Border> {
        private final boolean isLeftBorder;
        private final int offset;
        private final String text;

        private Border(boolean isLeftBorder, int offset, String text) {
            this.isLeftBorder = isLeftBorder;
            this.offset = offset;
            this.text = text;
        }

        @Override
        public int compareTo(@NotNull Border o) {
            return this.offset < o.offset ? 1 : -1;
        }
    }

    private static class SelectionAndCaretMarkupLoader {
        private final String filePath;
        private final String newFileText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, String filePath) {
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path, String charset) {
            return SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> FileUtil.loadFile((File)new File(path), (String)charset)), path);
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file2) {
            return SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> VfsUtilCore.loadText((VirtualFile)file2)), file2.getPath());
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromIoSource(@NotNull ThrowableComputable<String, IOException> source, String path) {
            try {
                return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)((String)source.compute())), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromText(@NotNull String text) {
            return new SelectionAndCaretMarkupLoader(text, null);
        }
    }
}

