/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.parameterInfo;

import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockUpdateParameterInfoContext
implements UpdateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private PsiElement myParameterOwner;
    private Object myHighlightedParameter;
    private int myCurrentParameter;
    private final Object[] myItems;
    private final boolean[] myCompEnabled;

    public MockUpdateParameterInfoContext(@NotNull Editor editor, @NotNull PsiFile file2) {
        this(editor, file2, null);
    }

    public MockUpdateParameterInfoContext(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable Object[] items) {
        this.myEditor = editor;
        this.myFile = file2;
        this.myItems = items == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : items;
        this.myCompEnabled = items == null ? null : new boolean[items.length];
    }

    public void removeHint() {
    }

    public void setParameterOwner(PsiElement o) {
        this.myParameterOwner = o;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object parameter) {
        this.myHighlightedParameter = parameter;
    }

    public Object getHighlightedParameter() {
        return this.myHighlightedParameter;
    }

    public void setCurrentParameter(int index) {
        this.myCurrentParameter = index;
    }

    public int getCurrentParameter() {
        return this.myCurrentParameter;
    }

    public boolean isUIComponentEnabled(int index) {
        return this.myCompEnabled != null && this.myCompEnabled[index];
    }

    public void setUIComponentEnabled(int index, boolean b) {
        if (this.myCompEnabled != null) {
            this.myCompEnabled[index] = b;
        }
    }

    public int getParameterListStart() {
        return this.myEditor.getCaretModel().getOffset();
    }

    public Object[] getObjectsToView() {
        return this.myItems;
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }
}

