/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestFramework
implements TestFramework {
    public boolean isLibraryAttached(@NotNull Module module2) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
        PsiClass c = JavaPsiFacade.getInstance((Project)module2.getProject()).findClass(this.getMarkerClassFQName(), scope);
        return c != null;
    }

    @Nullable
    public String getLibraryPath() {
        ExternalLibraryDescriptor descriptor = this.getFrameworkLibraryDescriptor();
        if (descriptor != null) {
            return descriptor.getLibraryClassesRoots().get(0);
        }
        return null;
    }

    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return null;
    }

    protected abstract String getMarkerClassFQName();

    public boolean isTestClass(@NotNull PsiElement clazz) {
        return clazz instanceof PsiClass && this.isTestClass((PsiClass)clazz, false);
    }

    public boolean isPotentialTestClass(@NotNull PsiElement clazz) {
        return clazz instanceof PsiClass && this.isTestClass((PsiClass)clazz, true);
    }

    protected abstract boolean isTestClass(PsiClass var1, boolean var2);

    protected boolean isUnderTestSources(PsiClass clazz) {
        PsiFile psiFile = clazz.getContainingFile();
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)clazz.getProject()).getFileIndex().isInTestSourceContent(vFile);
    }

    @Nullable
    public PsiElement findSetUpMethod(@NotNull PsiElement clazz) {
        return clazz instanceof PsiClass ? this.findSetUpMethod((PsiClass)clazz) : null;
    }

    @Nullable
    protected abstract PsiMethod findSetUpMethod(@NotNull PsiClass var1);

    @Nullable
    public PsiElement findTearDownMethod(@NotNull PsiElement clazz) {
        return clazz instanceof PsiClass ? this.findTearDownMethod((PsiClass)clazz) : null;
    }

    @Nullable
    protected abstract PsiMethod findTearDownMethod(@NotNull PsiClass var1);

    public PsiElement findOrCreateSetUpMethod(@NotNull PsiElement clazz) throws IncorrectOperationException {
        return clazz instanceof PsiClass ? this.findOrCreateSetUpMethod((PsiClass)clazz) : null;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        return false;
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @Nullable
    protected abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1) throws IncorrectOperationException;

    public boolean isParameterized(PsiClass clazz) {
        return false;
    }

    @Nullable
    public PsiMethod findParametersMethod(PsiClass clazz) {
        return null;
    }

    @Nullable
    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return null;
    }

    public abstract char getMnemonic();

    public PsiMethod createSetUpPatternMethod(JVMElementFactory factory) {
        FileTemplate template = FileTemplateManager.getDefaultInstance().getCodeTemplate(this.getSetUpMethodFileTemplateDescriptor().getFileName());
        String templateText = StringUtil.replace((String)StringUtil.replace((String)template.getText(), (String)"${BODY}\n", (String)""), (String)"${NAME}", (String)"setUp");
        return factory.createMethodFromText(templateText, null);
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return null;
    }

    public void setupLibrary(Module module2) {
        ExternalLibraryDescriptor descriptor = this.getFrameworkLibraryDescriptor();
        if (descriptor != null) {
            JavaProjectModelModificationService.getInstance(module2.getProject()).addDependency(module2, descriptor, DependencyScope.TEST);
        } else {
            String path = this.getLibraryPath();
            if (path != null) {
                OrderEntryFix.addJarsToRoots(Collections.singletonList(path), null, module2, null);
            }
        }
    }

    public boolean isSingleConfig() {
        return false;
    }

    public boolean isTestMethod(PsiMethod method2, PsiClass myClass) {
        return this.isTestMethod((PsiElement)method2);
    }

    public boolean acceptNestedClasses() {
        return false;
    }
}

